function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import ReactDOM from 'react-dom';
import { action } from '@storybook/addon-actions';
import { boolean, object, optionsKnob as options, select, text, withKnobs } from '@storybook/addon-knobs';
import Modal from '../Modal';
import Button from '../Button';
import Select from '../Select';
import SelectItem from '../SelectItem';
import TextInput from '../TextInput';
import mdx from './Modal.mdx';
var sizes = {
  'Extra small (xs)': 'xs',
  'Small (sm)': 'sm',
  'Medium (md)': 'md',
  'Large (lg)': 'lg'
};
var buttons = {
  'None (0)': '0',
  'One (1)': '1',
  'Two (2)': '2',
  'Three (3)': '3'
};
var props = {
  modal: function modal() {
    return {
      numberOfButtons: options('Number of Buttons', buttons, '2', {
        display: 'inline-radio'
      }),
      className: 'some-class',
      open: boolean('Open (open)', true),
      danger: boolean('Danger mode (danger)', false),
      alert: boolean('Alert mode (alert)', false),
      shouldSubmitOnEnter: boolean('Enter key to submit (shouldSubmitOnEnter)', false),
      hasScrollingContent: boolean('Modal contains scrollable content (hasScrollingContent)', false),
      hasForm: boolean('Modal contains a form (hasForm)', false),
      modalHeading: text('Modal heading (modalHeading)', 'Modal heading'),
      modalLabel: text('Optional label (modalLabel)', 'Label'),
      modalAriaLabel: text('ARIA label, used only if modalLabel not provided (modalAriaLabel)', 'A label to be read by screen readers on the modal root node'),
      selectorPrimaryFocus: text('Primary focus element selector (selectorPrimaryFocus)', '[data-modal-primary-focus]'),
      size: select('Size (size)', sizes, 'md'),
      iconDescription: text('Close icon description (iconDescription)', 'Close'),
      onBlur: action('onBlur'),
      onClick: action('onClick'),
      onFocus: action('onFocus'),
      onRequestClose: action('onRequestClose'),
      onRequestSubmit: action('onRequestSubmit'),
      onSecondarySubmit: action('onSecondarySubmit'),
      preventCloseOnClickOutside: boolean('Prevent closing on click outside of modal (preventCloseOnClickOutside)', true),
      primaryButtonDisabled: boolean('Disable primary button (primaryButtonDisabled)', false),
      primaryButtonText: text('Primary button text (primaryButtonText)', 'Primary button')
    };
  },
  modalFooter: function modalFooter(numberOfButtons) {
    var secondaryButtons = function secondaryButtons() {
      switch (numberOfButtons) {
        case '2':
          return {
            secondaryButtonText: text('Secondary button text (secondaryButtonText in <ModalFooter>)', 'Secondary button')
          };

        case '3':
          return {
            secondaryButtons: object('Secondary button config array (secondaryButtons)', [{
              buttonText: 'Keep both',
              onClick: action('onClick')
            }, {
              buttonText: 'Rename',
              onClick: action('onClick')
            }])
          };

        default:
          return null;
      }
    };

    return _objectSpread({
      passiveModal: boolean('Without footer (passiveModal)', false || numberOfButtons === '0')
    }, secondaryButtons());
  }
};
export default {
  title: 'Components/Modal',
  decorators: [withKnobs],
  parameters: {
    component: Modal,
    docs: {
      page: mdx
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(Modal, {
    open: true,
    modalHeading: "Add a custom domain",
    modalLabel: "Account resources",
    primaryButtonText: "Add",
    secondaryButtonText: "Cancel"
  }, /*#__PURE__*/React.createElement("p", {
    style: {
      marginBottom: '1rem'
    }
  }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host."), /*#__PURE__*/React.createElement(TextInput, {
    "data-modal-primary-focus": true,
    id: "text-input-1",
    labelText: "Domain name",
    placeholder: "e.g. github.com",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/React.createElement(Select, {
    id: "select-1",
    defaultValue: "us-south",
    labelText: "Region"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    value: "us-south",
    text: "US South"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "us-east",
    text: "US East"
  })));
};
export var Playground = function Playground() {
  var _props$modal = props.modal(),
      size = _props$modal.size,
      numberOfButtons = _props$modal.numberOfButtons,
      hasScrollingContent = _props$modal.hasScrollingContent,
      modalProps = _objectWithoutProperties(_props$modal, ["size", "numberOfButtons", "hasScrollingContent"]);

  var _props$modalFooter = props.modalFooter(numberOfButtons),
      passiveModal = _props$modalFooter.passiveModal,
      footerProps = _objectWithoutProperties(_props$modalFooter, ["passiveModal"]);

  return /*#__PURE__*/React.createElement(Modal, _extends({
    passiveModal: numberOfButtons === '0' || passiveModal,
    size: size || undefined,
    hasScrollingContent: hasScrollingContent,
    "aria-label": hasScrollingContent ? 'Modal content' : undefined
  }, modalProps, footerProps), /*#__PURE__*/React.createElement("p", {
    style: {
      marginBottom: '1rem'
    }
  }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host."), /*#__PURE__*/React.createElement(TextInput, {
    "data-modal-primary-focus": true,
    id: "text-input-1",
    labelText: "Domain name",
    placeholder: "e.g. github.com",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/React.createElement(Select, {
    id: "select-1",
    defaultValue: "us-south",
    labelText: "Region"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    value: "us-south",
    text: "US South"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "us-east",
    text: "US East"
  })), /*#__PURE__*/React.createElement("br", null), hasScrollingContent && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("h3", null, "Lorem ipsum"), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' ')));
};
export var WithStateManager = function WithStateManager() {
  /**
   * Simple state manager for modals.
   */
  var ModalStateManager = function ModalStateManager(_ref) {
    var LauncherContent = _ref.renderLauncher,
        ModalContent = _ref.children;

    var _useState = useState(false),
        _useState2 = _slicedToArray(_useState, 2),
        open = _useState2[0],
        setOpen = _useState2[1];

    return /*#__PURE__*/React.createElement(React.Fragment, null, !ModalContent || typeof document === 'undefined' ? null : /*#__PURE__*/ReactDOM.createPortal( /*#__PURE__*/React.createElement(ModalContent, {
      open: open,
      setOpen: setOpen
    }), document.body), LauncherContent && /*#__PURE__*/React.createElement(LauncherContent, {
      open: open,
      setOpen: setOpen
    }));
  };

  return /*#__PURE__*/React.createElement(ModalStateManager, {
    renderLauncher: function renderLauncher(_ref2) {
      var setOpen = _ref2.setOpen;
      return /*#__PURE__*/React.createElement(Button, {
        onClick: function onClick() {
          return setOpen(true);
        }
      }, "Launch modal");
    }
  }, function (_ref3) {
    var open = _ref3.open,
        setOpen = _ref3.setOpen;
    return /*#__PURE__*/React.createElement(Modal, {
      modalHeading: "Add a custom domain",
      modalLabel: "Account resources",
      primaryButtonText: "Add",
      secondaryButtonText: "Cancel",
      open: open,
      onRequestClose: function onRequestClose() {
        return setOpen(false);
      }
    }, /*#__PURE__*/React.createElement("p", {
      style: {
        marginBottom: '1rem'
      }
    }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host."), /*#__PURE__*/React.createElement(TextInput, {
      "data-modal-primary-focus": true,
      id: "text-input-1",
      labelText: "Domain name",
      placeholder: "e.g. github.com",
      style: {
        marginBottom: '1rem'
      }
    }), /*#__PURE__*/React.createElement(Select, {
      id: "select-1",
      defaultValue: "us-south",
      labelText: "Region"
    }, /*#__PURE__*/React.createElement(SelectItem, {
      value: "us-south",
      text: "US South"
    }), /*#__PURE__*/React.createElement(SelectItem, {
      value: "us-east",
      text: "US East"
    })));
  });
};
export var PassiveModal = function PassiveModal() {
  return /*#__PURE__*/React.createElement(Modal, {
    open: true,
    passiveModal: true,
    modalHeading: "You have been successfully signed out"
  });
};