import React from 'react';
import { action } from '@storybook/addon-actions';
import { InlineNotification } from '../Notification';
import { MenuDivider, MenuGroup, MenuItem, MenuRadioGroup, MenuSelectableItem } from '../Menu';

var InfoBanner = function InfoBanner() {
  return /*#__PURE__*/React.createElement(InlineNotification, {
    kind: "info",
    title: "Experimental component",
    subtitle: "This component is considered experimental. Its API may change until the stable version is released.",
    lowContrast: true,
    hideCloseButton: true
  });
}; // eslint-disable-next-line react/prop-types


export var StoryFrame = function StoryFrame(_ref) {
  var children = _ref.children;
  return /*#__PURE__*/React.createElement("div", {
    style: {
      height: 'calc(100vh - 6.25rem)'
    }
  }, /*#__PURE__*/React.createElement(InfoBanner, null), children);
};

function renderItem(item, i) {
  switch (item.type) {
    case 'item':
      return /*#__PURE__*/React.createElement(MenuItem, {
        key: i,
        label: item.label,
        shortcut: item.shortcut,
        disabled: item.disabled,
        kind: item.kind,
        onClick: !item.children ? action('onClick') : null
      }, item.children && item.children.map(renderItem));

    case 'divider':
      return /*#__PURE__*/React.createElement(MenuDivider, {
        key: i
      });

    case 'selectable':
      return /*#__PURE__*/React.createElement(MenuSelectableItem, {
        key: i,
        label: item.label,
        initialChecked: item.initialChecked,
        onChange: action('onChange')
      });

    case 'radiogroup':
      return /*#__PURE__*/React.createElement(MenuRadioGroup, {
        key: i,
        label: item.label,
        items: item.items,
        initialSelectedItem: item.initialSelectedItem,
        onChange: action('onChange')
      });

    case 'group':
      return /*#__PURE__*/React.createElement(MenuGroup, {
        key: i,
        label: item.label
      }, item.children && item.children.map(renderItem));
  }
}

export var buildMenu = function buildMenu(items) {
  return items.map(renderItem);
};