function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PropTypes from 'prop-types';
import MenuOption from './MenuOption';

function MenuItem(_ref) {
  var label = _ref.label,
      children = _ref.children,
      disabled = _ref.disabled,
      kind = _ref.kind,
      shortcut = _ref.shortcut,
      rest = _objectWithoutProperties(_ref, ["label", "children", "disabled", "kind", "shortcut"]);

  return /*#__PURE__*/React.createElement(MenuOption, _extends({}, rest, {
    label: label,
    disabled: disabled,
    kind: kind,
    shortcut: shortcut
  }), children);
}

MenuItem.propTypes = {
  /**
   * Specify the children of the MenuItem
   */
  children: PropTypes.node,

  /**
   * Specify whether this MenuItem is disabled
   */
  disabled: PropTypes.bool,

  /**
   * Optional prop to specify the kind of the MenuItem
   */
  kind: PropTypes.oneOf(['default', 'danger']),

  /**
   * Rendered label for the MenuItem
   */
  label: PropTypes.node.isRequired,

  /**
   * Rendered shortcut for the MenuItem
   */
  shortcut: PropTypes.node
};
export default MenuItem;