function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright IBM Corp. 2021
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState, useRef, useEffect } from 'react';
import classnames from 'classnames';
import { settings } from 'carbon-components';
import Search from '../Search';
var prefix = settings.prefix;

function ExpandableSearch(props) {
  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      expanded = _useState2[0],
      setExpanded = _useState2[1];

  var searchRef = useRef(null);

  function handleFocus() {
    if (!expanded) {
      setExpanded(true);
    }
  }

  function handleBlur(evt) {
    var relatedTargetIsAllowed = evt.relatedTarget && evt.relatedTarget.classList.contains("".concat(prefix, "--search-close"));

    if (expanded && !relatedTargetIsAllowed && !searchRef.current.state.hasContent) {
      setExpanded(false);
    }
  }

  useEffect(function () {
    var _searchRef$current2;

    function focusInput() {
      var _searchRef$current;

      if (!expanded && (_searchRef$current = searchRef.current) !== null && _searchRef$current !== void 0 && _searchRef$current.input) {
        searchRef.current.input.focus();
      }
    }

    if ((_searchRef$current2 = searchRef.current) !== null && _searchRef$current2 !== void 0 && _searchRef$current2.magnifier) {
      var magnifier = searchRef.current.magnifier;
      magnifier.addEventListener('click', focusInput);
      return function () {
        magnifier.removeEventListener('click', focusInput);
      };
    }
  }, [expanded, searchRef]);
  var classes = classnames("".concat(prefix, "--search--expandable"), _defineProperty({}, "".concat(prefix, "--search--expanded"), expanded), props.className);
  return /*#__PURE__*/React.createElement(Search, _extends({}, props, {
    ref: searchRef,
    className: classes,
    onFocus: handleFocus,
    onBlur: handleBlur
  }));
}

ExpandableSearch.propTypes = Search.propTypes;
export default ExpandableSearch;