function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import { action } from '@storybook/addon-actions';
import { ErrorBoundary, ErrorBoundaryContext } from './';
import Button from '../Button';
export default {
  title: 'Components/ErrorBoundary',
  parameters: {
    component: ErrorBoundary
  }
};
export var Default = function Default() {
  function DemoComponent() {
    var _useState = useState(false),
        _useState2 = _slicedToArray(_useState, 2),
        shouldThrowError = _useState2[0],
        setShouldThrowError = _useState2[1];

    function onClick() {
      setShouldThrowError(!shouldThrowError);
    }

    return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Button, {
      onClick: onClick
    }, "Toggle throwing error"), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(ErrorBoundary, {
      fallback: /*#__PURE__*/React.createElement(Fallback, null)
    }, /*#__PURE__*/React.createElement(ThrowError, {
      shouldThrowError: shouldThrowError
    }))));
  }

  function Fallback() {
    return 'Whoops';
  }

  function ThrowError(_ref) {
    var shouldThrowError = _ref.shouldThrowError;

    if (shouldThrowError) {
      throw new Error('Component threw error');
    }

    return 'Successfully rendered';
  }

  return /*#__PURE__*/React.createElement(DemoComponent, null);
};
Default.storyName = 'default';
export var WithCustomContext = function WithCustomContext() {
  function DemoComponent() {
    var _useState3 = useState(false),
        _useState4 = _slicedToArray(_useState3, 2),
        shouldThrowError = _useState4[0],
        setShouldThrowError = _useState4[1];

    function onClick() {
      setShouldThrowError(!shouldThrowError);
    }

    return /*#__PURE__*/React.createElement(ErrorBoundaryContext.Provider, {
      value: {
        log: action('log')
      }
    }, /*#__PURE__*/React.createElement(Button, {
      onClick: onClick
    }, "Toggle throwing error"), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(ErrorBoundary, {
      fallback: /*#__PURE__*/React.createElement(Fallback, null)
    }, /*#__PURE__*/React.createElement(ThrowError, {
      shouldThrowError: shouldThrowError
    }))));
  }

  function Fallback() {
    return 'Whoops';
  }

  function ThrowError(_ref2) {
    var shouldThrowError = _ref2.shouldThrowError;

    if (shouldThrowError) {
      throw new Error('Component threw error');
    }

    return 'Successfully rendered';
  }

  return /*#__PURE__*/React.createElement(DemoComponent, null);
};
WithCustomContext.storyName = 'with custom context';