function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { settings } from 'carbon-components';
var prefix = settings.prefix;

var DataTableSkeleton = function DataTableSkeleton(_ref) {
  var _cx;

  var headers = _ref.headers,
      rowCount = _ref.rowCount,
      columnCount = _ref.columnCount,
      zebra = _ref.zebra,
      compact = _ref.compact,
      className = _ref.className,
      showHeader = _ref.showHeader,
      showToolbar = _ref.showToolbar,
      rest = _objectWithoutProperties(_ref, ["headers", "rowCount", "columnCount", "zebra", "compact", "className", "showHeader", "showToolbar"]);

  var dataTableSkeletonClasses = cx(className, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--skeleton"), true), _defineProperty(_cx, "".concat(prefix, "--data-table"), true), _defineProperty(_cx, "".concat(prefix, "--data-table--zebra"), zebra), _defineProperty(_cx, "".concat(prefix, "--data-table--compact"), compact), _cx));
  var rowRepeat = rowCount;
  var rows = Array(rowRepeat);
  var columnsArray = Array.from({
    length: columnCount
  }, function (_, index) {
    return index;
  });

  for (var i = 0; i < rowRepeat; i++) {
    rows[i] = /*#__PURE__*/React.createElement("tr", {
      key: i
    }, columnsArray.map(function (j) {
      return /*#__PURE__*/React.createElement("td", {
        key: j
      }, /*#__PURE__*/React.createElement("span", null));
    }));
  }

  return /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--skeleton ").concat(prefix, "--data-table-container")
  }, showHeader ? /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--data-table-header")
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--data-table-header__title")
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--data-table-header__description")
  })) : null, showToolbar ? /*#__PURE__*/React.createElement("section", {
    "aria-label": "data table toolbar",
    className: "".concat(prefix, "--table-toolbar")
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--toolbar-content")
  }, /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--skeleton ").concat(prefix, "--btn ").concat(prefix, "--btn--sm")
  }))) : null, /*#__PURE__*/React.createElement("table", _extends({
    className: dataTableSkeletonClasses
  }, rest), /*#__PURE__*/React.createElement("thead", null, /*#__PURE__*/React.createElement("tr", null, columnsArray.map(function (i) {
    var _headers$i;

    return /*#__PURE__*/React.createElement("th", {
      key: i
    }, headers ? /*#__PURE__*/React.createElement("div", {
      className: "bx--table-header-label"
    }, (_headers$i = headers[i]) === null || _headers$i === void 0 ? void 0 : _headers$i.header) : /*#__PURE__*/React.createElement("span", null));
  }))), /*#__PURE__*/React.createElement("tbody", null, rows)));
};

DataTableSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: PropTypes.string,

  /**
   * Specify the number of columns that you want to render in the skeleton state
   */
  columnCount: PropTypes.number,

  /**
   * Optionally specify whether you want the Skeleton to be rendered as a
   * compact DataTable
   */
  compact: PropTypes.bool,

  /**
   * Optionally specify the displayed headers
   */
  headers: PropTypes.oneOfType([PropTypes.array, PropTypes.shape({
    key: PropTypes.string
  })]),

  /**
   * Specify the number of rows that you want to render in the skeleton state
   */
  rowCount: PropTypes.number,

  /**
   * Specify if the table header should be rendered as part of the skeleton.
   */
  showHeader: PropTypes.bool,

  /**
   * Specify if the table toolbar should be rendered as part of the skeleton.
   */
  showToolbar: PropTypes.bool,

  /**
   * Optionally specify whether you want the DataTable to be zebra striped
   */
  zebra: PropTypes.bool
};
DataTableSkeleton.defaultProps = {
  rowCount: 5,
  columnCount: 5,
  zebra: false,
  compact: false,
  showHeader: true,
  showToolbar: true
};
export default DataTableSkeleton;