/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import Link from '../../Link';
export var rows = [{
  id: 'a',
  name: 'Load Balancer 3',
  protocol: 'HTTP',
  port: 3000,
  rule: 'Round robin',
  attached_groups: 'Kevin’s VM Groups',
  status: /*#__PURE__*/React.createElement(Link, null, "Disabled")
}, {
  id: 'b',
  name: 'Load Balancer 1',
  protocol: 'HTTP',
  port: 443,
  rule: 'Round robin',
  attached_groups: 'Maureen’s VM Groups',
  status: /*#__PURE__*/React.createElement(Link, null, "Starting")
}, {
  id: 'c',
  name: 'Load Balancer 2',
  protocol: 'HTTP',
  port: 80,
  rule: 'DNS delegation',
  attached_groups: 'Andrew’s VM Groups',
  status: /*#__PURE__*/React.createElement(Link, null, "Active")
}, {
  id: 'd',
  name: 'Load Balancer 6',
  protocol: 'HTTP',
  port: 3000,
  rule: 'Round robin',
  attached_groups: 'Marc’s VM Groups',
  status: /*#__PURE__*/React.createElement(Link, null, "Disabled")
}, {
  id: 'e',
  name: 'Load Balancer 4',
  protocol: 'HTTP',
  port: 443,
  rule: 'Round robin',
  attached_groups: 'Mel’s VM Groups',
  status: /*#__PURE__*/React.createElement(Link, null, "Starting")
}, {
  id: 'f',
  name: 'Load Balancer 5',
  protocol: 'HTTP',
  port: 80,
  rule: 'DNS delegation',
  attached_groups: 'Ronja’s VM Groups',
  status: /*#__PURE__*/React.createElement(Link, null, "Active")
}];
export var headers = [{
  key: 'name',
  header: 'Name'
}, {
  key: 'protocol',
  header: 'Protocol'
}, {
  key: 'port',
  header: 'Port'
}, {
  key: 'rule',
  header: 'Rule'
}, {
  key: 'attached_groups',
  header: 'Attached Groups'
}, {
  key: 'status',
  header: 'Status'
}];
export var batchActionClick = function batchActionClick(selectedRows) {
  return function () {
    return action('batch action click')(selectedRows);
  };
};