var _sortDirections;

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { settings } from 'carbon-components';
import { ArrowUp20 as Arrow, ArrowsVertical20 as Arrows } from '@carbon/icons-react';
import { sortStates } from './state/sorting';
import { useId } from '../../internal/useId';
var prefix = settings.prefix;
var translationKeys = {
  buttonDescription: 'carbon.table.header.icon.description'
};

var translateWithId = function translateWithId(key, _ref) {
  var header = _ref.header,
      sortDirection = _ref.sortDirection,
      isSortHeader = _ref.isSortHeader,
      sortStates = _ref.sortStates;

  if (key === translationKeys.buttonDescription) {
    if (isSortHeader) {
      // When transitioning, we know that the sequence of states is as follows:
      // NONE -> ASC -> DESC -> NONE
      if (sortDirection === sortStates.NONE) {
        return "Click to sort rows by ".concat(header, " header in ascending order");
      }

      if (sortDirection === sortStates.ASC) {
        return "Click to sort rows by ".concat(header, " header in descending order");
      }

      return "Click to unsort rows by ".concat(header, " header");
    }

    return "Click to sort rows by ".concat(header, " header in ascending order");
  }

  return '';
};

var sortDirections = (_sortDirections = {}, _defineProperty(_sortDirections, sortStates.NONE, 'none'), _defineProperty(_sortDirections, sortStates.ASC, 'ascending'), _defineProperty(_sortDirections, sortStates.DESC, 'descending'), _sortDirections);
var TableHeader = /*#__PURE__*/React.forwardRef(function TableHeader(_ref2, ref) {
  var _cx;

  var headerClassName = _ref2.className,
      children = _ref2.children,
      colSpan = _ref2.colSpan,
      isSortable = _ref2.isSortable,
      isSortHeader = _ref2.isSortHeader,
      onClick = _ref2.onClick,
      scope = _ref2.scope,
      sortDirection = _ref2.sortDirection,
      t = _ref2.translateWithId,
      rest = _objectWithoutProperties(_ref2, ["className", "children", "colSpan", "isSortable", "isSortHeader", "onClick", "scope", "sortDirection", "translateWithId"]);

  var uniqueId = useId('table-sort');

  if (!isSortable) {
    return /*#__PURE__*/React.createElement("th", _extends({}, rest, {
      className: headerClassName,
      scope: scope,
      colSpan: colSpan,
      ref: ref
    }), children ? /*#__PURE__*/React.createElement("div", {
      className: "".concat(prefix, "--table-header-label")
    }, children) : null);
  }

  var className = cx(headerClassName, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--table-sort"), true), _defineProperty(_cx, "".concat(prefix, "--table-sort--active"), isSortHeader && sortDirection !== sortStates.NONE), _defineProperty(_cx, "".concat(prefix, "--table-sort--ascending"), isSortHeader && sortDirection === sortStates.DESC), _cx));
  var ariaSort = !isSortHeader ? 'none' : sortDirections[sortDirection];
  var sortDescription = t('carbon.table.header.icon.description', {
    header: children,
    sortDirection: sortDirection,
    isSortHeader: isSortHeader,
    sortStates: sortStates
  });
  return /*#__PURE__*/React.createElement("th", {
    "aria-sort": ariaSort,
    className: headerClassName,
    colSpan: colSpan,
    ref: ref,
    scope: scope
  }, /*#__PURE__*/React.createElement("div", {
    style: {
      display: 'none'
    },
    id: uniqueId
  }, sortDescription), /*#__PURE__*/React.createElement("button", _extends({
    type: "button",
    "aria-describedby": uniqueId,
    className: className,
    onClick: onClick
  }, rest), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--table-sort__flex")
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--table-header-label")
  }, children), /*#__PURE__*/React.createElement(Arrow, {
    className: "".concat(prefix, "--table-sort__icon")
  }), /*#__PURE__*/React.createElement(Arrows, {
    className: "".concat(prefix, "--table-sort__icon-unsorted")
  }))));
});
TableHeader.propTypes = {
  /**
   * Pass in children that will be embedded in the table header label
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify `colSpan` as a non-negative integer value to indicate how
   * many columns the TableHeader cell extends in a table
   */
  colSpan: PropTypes.number,

  /**
   * Specify whether this header is the header by which a table is being sorted
   * by
   */
  isSortHeader: PropTypes.bool,

  /**
   * Specify whether this header is one through which a user can sort the table
   */
  isSortable: PropTypes.bool,

  /**
   * Hook that is invoked when the header is clicked
   */
  onClick: PropTypes.func,

  /**
   * Specify the scope of this table header. You can find more info about this
   * attribute at the following URL:
   * https://developer.mozilla.org/en-US/docs/Web/HTML/Element/th#attr-scope
   */
  scope: PropTypes.string.isRequired,

  /**
   * Specify which direction we are currently sorting by, should be one of DESC,
   * NONE, or ASC.
   */
  sortDirection: PropTypes.oneOf(Object.values(sortStates)),

  /**
   * Supply a method to translate internal strings with your i18n tool of
   * choice. Translation keys are avabile on the `translationKeys` field for
   * this component.
   */
  translateWithId: PropTypes.func
};
TableHeader.defaultProps = {
  isSortable: false,
  scope: 'col',
  translateWithId: translateWithId
};
TableHeader.translationKeys = Object.values(translationKeys);
TableHeader.displayName = 'TableHeader';
export default TableHeader;