/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import Copy from '../Copy';
import { shallow, mount } from 'enzyme';
import { settings } from 'carbon-components';
var prefix = settings.prefix;
jest.useFakeTimers();
describe('Copy', function () {
  describe('Renders common props as expected', function () {
    var wrapper = shallow(
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/tabindex-no-positive
    React.createElement(Copy, {
      tabIndex: 2,
      className: "extra-class"
    }));
    it('Should set tabIndex if one is passed via props', function () {
      expect(wrapper.props().tabIndex).toEqual(2);
    });
    it('Should add extra classes via className', function () {
      expect(wrapper.hasClass('extra-class')).toBe(true);
    });
  });
  describe('Renders button props as expected', function () {
    var wrapper = shallow( /*#__PURE__*/React.createElement(Copy, null));
    it('Should be able to disable the button', function () {
      wrapper.setProps({
        disabled: true
      });
      expect(wrapper.props().disabled).toBe(true);
      wrapper.setProps({
        disabled: false
      });
    });
    it('Should have a default feedback timeout', function () {
      var timeoutWrapper = mount( /*#__PURE__*/React.createElement(Copy, null));
      expect(timeoutWrapper.props().feedbackTimeout).toBe(2000);
    });
    it('Should be able to set the timeout for displaying feedback', function () {
      var timeoutWrapper = mount( /*#__PURE__*/React.createElement(Copy, {
        feedbackTimeout: 5000
      }));
      expect(timeoutWrapper.props().feedbackTimeout).toBe(5000);
    });
    it('Should be able to specify the feedback message', function () {
      var feedbackWrapper = mount( /*#__PURE__*/React.createElement(Copy, {
        feedback: "Copied!"
      }));
      expect(feedbackWrapper.find(".".concat(prefix, "--copy-btn__feedback")).text()).toBe('Copied!');
    });
  });
  describe('Renders feedback as expected', function () {
    it('Should make the feedback visible', function () {
      var feedbackWrapper = mount( /*#__PURE__*/React.createElement(Copy, {
        feedback: "Copied!"
      }));
      var feedback = feedbackWrapper.find(".".concat(prefix, "--copy-btn__feedback"));
      expect(feedback).toBeFalsy;
      feedbackWrapper.simulate('click');
      expect(feedback).toBeTruthy;
    });
    it('Should show feedback for a limited amount of time', function () {
      var feedbackWrapper = mount( /*#__PURE__*/React.createElement(Copy, {
        feedback: "Copied!",
        feedbackTimeout: 5000
      }));
      feedbackWrapper.simulate('click');
      var copyButton = feedbackWrapper.find('button');
      expect(copyButton.hasClass("".concat(prefix, "--copy-btn--animating"))).toBe(true);
      setTimeout(function () {
        expect(copyButton.hasClass("".concat(prefix, "--copy-btn--animating"))).toBe(false);
      }, 5220); // 5000 + 2 * 110 (transition duration)
    });
  });
  describe('Triggers appropriate events', function () {
    it('should call the click handler', function () {
      var onClick = jest.fn();
      var clickWrapper = mount( /*#__PURE__*/React.createElement(Copy, {
        onClick: onClick
      }));
      clickWrapper.simulate('click');
      expect(onClick).toBeCalled();
    });
  });
});