function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import Downshift from 'downshift';
import PropTypes from 'prop-types';
import React, { useEffect, useState, useRef } from 'react';
import { settings } from 'carbon-components';
import { Checkmark16, WarningAltFilled16, WarningFilled16 } from '@carbon/icons-react';
import ListBox, { PropTypes as ListBoxPropTypes } from '../ListBox';
import { ListBoxTrigger, ListBoxSelection } from '../ListBox/next';
import { match, keys } from '../../internal/keyboard';
import setupGetInstanceId from '../../tools/setupGetInstanceId';
import { mapDownshiftProps } from '../../tools/createPropAdapter';
import mergeRefs from '../../tools/mergeRefs';
var prefix = settings.prefix;

var defaultItemToString = function defaultItemToString(item) {
  if (typeof item === 'string') {
    return item;
  }

  return item && item.label;
};

var defaultShouldFilterItem = function defaultShouldFilterItem() {
  return true;
};

var getInputValue = function getInputValue(_ref) {
  var initialSelectedItem = _ref.initialSelectedItem,
      inputValue = _ref.inputValue,
      itemToString = _ref.itemToString,
      selectedItem = _ref.selectedItem;

  if (selectedItem) {
    return itemToString(selectedItem);
  } // TODO: consistent `initialSelectedItem` behavior with other listbox components in v11


  if (initialSelectedItem) {
    return itemToString(initialSelectedItem);
  }

  return inputValue || '';
};

var findHighlightedIndex = function findHighlightedIndex(_ref2, inputValue) {
  var items = _ref2.items,
      itemToString = _ref2.itemToString;

  if (!inputValue) {
    return -1;
  }

  var searchValue = inputValue.toLowerCase();

  for (var i = 0; i < items.length; i++) {
    var item = itemToString(items[i]).toLowerCase();

    if (item.indexOf(searchValue) !== -1) {
      return i;
    }
  }

  return -1;
};

var getInstanceId = setupGetInstanceId();

var ComboBox = function ComboBox(props) {
  var _cx;

  var ariaLabel = props.ariaLabel,
      containerClassName = props.className,
      direction = props.direction,
      disabled = props.disabled,
      downshiftProps = props.downshiftProps,
      helperText = props.helperText,
      id = props.id,
      initialSelectedItem = props.initialSelectedItem,
      invalid = props.invalid,
      invalidText = props.invalidText,
      items = props.items,
      itemToElement = props.itemToElement,
      itemToString = props.itemToString,
      light = props.light,
      onChange = props.onChange,
      onInputChange = props.onInputChange,
      onToggleClick = props.onToggleClick,
      placeholder = props.placeholder,
      selectedItem = props.selectedItem,
      shouldFilterItem = props.shouldFilterItem,
      size = props.size,
      titleText = props.titleText,
      translateWithId = props.translateWithId,
      type = props.type,
      warn = props.warn,
      warnText = props.warnText,
      rest = _objectWithoutProperties(props, ["ariaLabel", "className", "direction", "disabled", "downshiftProps", "helperText", "id", "initialSelectedItem", "invalid", "invalidText", "items", "itemToElement", "itemToString", "light", "onChange", "onInputChange", "onToggleClick", "placeholder", "selectedItem", "shouldFilterItem", "size", "titleText", "translateWithId", "type", "warn", "warnText"]);

  var textInput = useRef();
  var comboBoxInstanceId = getInstanceId();

  var _useState = useState(getInputValue({
    initialSelectedItem: initialSelectedItem,
    inputValue: '',
    itemToString: itemToString,
    selectedItem: selectedItem
  })),
      _useState2 = _slicedToArray(_useState, 2),
      inputValue = _useState2[0],
      setInputValue = _useState2[1];

  var _useState3 = useState(null),
      _useState4 = _slicedToArray(_useState3, 2),
      prevSelectedItem = _useState4[0],
      setPrevSelectedItem = _useState4[1];

  var _useState5 = useState(null),
      _useState6 = _slicedToArray(_useState5, 2),
      doneInitialSelectedItem = _useState6[0],
      setDoneInitialSelectedItem = _useState6[1];

  var savedOnInputChange = useRef(onInputChange);

  if (!doneInitialSelectedItem || prevSelectedItem !== selectedItem) {
    setDoneInitialSelectedItem(true);
    setPrevSelectedItem(selectedItem);
    setInputValue(getInputValue({
      initialSelectedItem: initialSelectedItem,
      inputValue: inputValue,
      itemToString: itemToString,
      selectedItem: selectedItem
    }));
  }

  var filterItems = function filterItems(items, itemToString, inputValue) {
    return items.filter(function (item) {
      return shouldFilterItem({
        item: item,
        itemToString: itemToString,
        inputValue: inputValue
      });
    });
  };

  var handleOnChange = function handleOnChange(selectedItem) {
    if (onChange) {
      onChange({
        selectedItem: selectedItem
      });
    }
  };

  var handleOnInputValueChange = function handleOnInputValueChange(inputValue) {
    setInputValue(inputValue || '');
  };

  useEffect(function () {
    savedOnInputChange.current = onInputChange;
  }, [onInputChange]);
  useEffect(function () {
    if (savedOnInputChange.current) {
      savedOnInputChange.current(inputValue);
    }
  }, [inputValue]);

  var handleSelectionClear = function handleSelectionClear() {
    if (textInput !== null && textInput !== void 0 && textInput.current) {
      textInput.current.focus();
    }
  };

  var handleOnStateChange = function handleOnStateChange(newState, _ref3) {
    var setHighlightedIndex = _ref3.setHighlightedIndex;

    if (Object.prototype.hasOwnProperty.call(newState, 'inputValue')) {
      var _inputValue = newState.inputValue;
      var filteredItems = filterItems(items, itemToString, _inputValue);
      setHighlightedIndex(findHighlightedIndex(_objectSpread(_objectSpread({}, props), {}, {
        items: filteredItems
      }), _inputValue));
    }
  };

  var handleToggleClick = function handleToggleClick(isOpen) {
    return function (event) {
      if (onToggleClick) {
        onToggleClick(event);
      }

      if (event.target === textInput.current && isOpen) {
        event.preventDownshiftDefault = true;
        event.persist();
      }
    };
  };

  var showWarning = !invalid && warn;
  var className = cx("".concat(prefix, "--combo-box"), containerClassName, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--list-box--up"), direction === 'top'), _defineProperty(_cx, "".concat(prefix, "--combo-box--warning"), showWarning), _cx));
  var titleClasses = cx("".concat(prefix, "--label"), _defineProperty({}, "".concat(prefix, "--label--disabled"), disabled));
  var comboBoxHelperId = !helperText ? undefined : "combobox-helper-text-".concat(comboBoxInstanceId);
  var helperClasses = cx("".concat(prefix, "--form__helper-text"), _defineProperty({}, "".concat(prefix, "--form__helper-text--disabled"), disabled));
  var wrapperClasses = cx("".concat(prefix, "--list-box__wrapper"));
  var inputClasses = cx("".concat(prefix, "--text-input"), _defineProperty({}, "".concat(prefix, "--text-input--empty"), !inputValue)); // needs to be Capitalized for react to render it correctly

  var ItemToElement = itemToElement;
  return /*#__PURE__*/React.createElement(Downshift, _extends({}, mapDownshiftProps(downshiftProps), {
    onChange: handleOnChange,
    onInputValueChange: handleOnInputValueChange,
    onStateChange: handleOnStateChange,
    inputValue: inputValue || '',
    itemToString: itemToString,
    initialSelectedItem: initialSelectedItem,
    inputId: id,
    selectedItem: selectedItem
  }), function (_ref4) {
    var getInputProps = _ref4.getInputProps,
        getItemProps = _ref4.getItemProps,
        getLabelProps = _ref4.getLabelProps,
        getMenuProps = _ref4.getMenuProps,
        getRootProps = _ref4.getRootProps,
        getToggleButtonProps = _ref4.getToggleButtonProps,
        isOpen = _ref4.isOpen,
        inputValue = _ref4.inputValue,
        selectedItem = _ref4.selectedItem,
        highlightedIndex = _ref4.highlightedIndex,
        clearSelection = _ref4.clearSelection,
        toggleMenu = _ref4.toggleMenu;
    var rootProps = getRootProps({}, {
      suppressRefError: true
    });
    var labelProps = getLabelProps();
    var buttonProps = getToggleButtonProps({
      disabled: disabled,
      onClick: handleToggleClick(isOpen),
      // When we moved the "root node" of Downshift to the <input> for
      // ARIA 1.2 compliance, we unfortunately hit this branch for the
      // "mouseup" event that downshift listens to:
      // https://github.com/downshift-js/downshift/blob/v5.2.1/src/downshift.js#L1051-L1065
      //
      // As a result, it will reset the state of the component and so we
      // stop the event from propagating to prevent this. This allows the
      // toggleMenu behavior for the toggleButton to correctly open and
      // close the menu.
      onMouseUp: function onMouseUp(event) {
        event.stopPropagation();
      }
    });
    var inputProps = getInputProps({
      // Remove excess aria `aria-labelledby`. HTML <label for> provides this aria information.
      'aria-labelledby': null,
      disabled: disabled,
      placeholder: placeholder,
      onClick: function onClick() {
        toggleMenu();
      },
      onKeyDown: function onKeyDown(event) {
        if (match(event, keys.Space)) {
          event.stopPropagation();
        }

        if (match(event, keys.Enter) && !inputValue) {
          toggleMenu();
        }
      }
    });
    return /*#__PURE__*/React.createElement("div", {
      className: wrapperClasses
    }, titleText && /*#__PURE__*/React.createElement("label", _extends({
      className: titleClasses
    }, labelProps), titleText), /*#__PURE__*/React.createElement(ListBox, {
      className: className,
      disabled: disabled,
      invalid: invalid,
      invalidText: invalidText,
      isOpen: isOpen,
      light: light,
      size: size,
      warn: warn,
      warnText: warnText
    }, /*#__PURE__*/React.createElement("div", {
      className: "".concat(prefix, "--list-box__field")
    }, /*#__PURE__*/React.createElement("input", _extends({
      role: "combobox",
      disabled: disabled,
      className: inputClasses,
      type: "text",
      tabIndex: "0",
      "aria-autocomplete": "list",
      "aria-expanded": rootProps['aria-expanded'],
      "aria-haspopup": "listbox",
      "aria-controls": inputProps['aria-controls']
    }, inputProps, rest, {
      ref: mergeRefs(textInput, rootProps.ref)
    })), invalid && /*#__PURE__*/React.createElement(WarningFilled16, {
      className: "".concat(prefix, "--list-box__invalid-icon")
    }), showWarning && /*#__PURE__*/React.createElement(WarningAltFilled16, {
      className: "".concat(prefix, "--list-box__invalid-icon ").concat(prefix, "--list-box__invalid-icon--warning")
    }), inputValue && /*#__PURE__*/React.createElement(ListBoxSelection, {
      clearSelection: clearSelection,
      translateWithId: translateWithId,
      disabled: disabled,
      onClearSelection: handleSelectionClear
    }), /*#__PURE__*/React.createElement(ListBoxTrigger, _extends({}, buttonProps, {
      isOpen: isOpen,
      translateWithId: translateWithId
    }))), /*#__PURE__*/React.createElement(ListBox.Menu, getMenuProps({
      'aria-label': ariaLabel
    }), isOpen ? filterItems(items, itemToString, inputValue).map(function (item, index) {
      var _getItemProps;

      var itemProps = getItemProps((_getItemProps = {
        item: item,
        index: index
      }, _defineProperty(_getItemProps, 'aria-current', selectedItem === item ? true : null), _defineProperty(_getItemProps, 'aria-selected', highlightedIndex === index ? true : null), _getItemProps));
      return /*#__PURE__*/React.createElement(ListBox.MenuItem, _extends({
        key: itemProps.id,
        isActive: selectedItem === item,
        tabIndex: "-1",
        isHighlighted: highlightedIndex === index || (selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.id) && (selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.id) === item.id || false,
        title: itemToElement ? item.text : itemToString(item)
      }, itemProps), itemToElement ? /*#__PURE__*/React.createElement(ItemToElement, _extends({
        key: itemProps.id
      }, item)) : itemToString(item), selectedItem === item && /*#__PURE__*/React.createElement(Checkmark16, {
        className: "".concat(prefix, "--list-box__menu-item__selected-icon")
      }));
    }) : null)), helperText && !invalid && !warn && /*#__PURE__*/React.createElement("div", {
      id: comboBoxHelperId,
      className: helperClasses
    }, helperText));
  });
};

ComboBox.propTypes = {
  /**
   * 'aria-label' of the ListBox component.
   */
  ariaLabel: PropTypes.string,

  /**
   * An optional className to add to the container node
   */
  className: PropTypes.string,

  /**
   * Specify the direction of the combobox dropdown. Can be either top or bottom.
   */
  direction: PropTypes.oneOf(['top', 'bottom']),

  /**
   * Specify if the control should be disabled, or not
   */
  disabled: PropTypes.bool,

  /**
   * Additional props passed to Downshift
   */
  downshiftProps: PropTypes.shape(Downshift.propTypes),

  /**
   * Provide helper text that is used alongside the control label for
   * additional help
   */
  helperText: PropTypes.string,

  /**
   * Specify a custom `id` for the input
   */
  id: PropTypes.string.isRequired,

  /**
   * Allow users to pass in an arbitrary item or a string (in case their items are an array of strings)
   * from their collection that are pre-selected
   */
  initialSelectedItem: PropTypes.oneOfType([PropTypes.object, PropTypes.string]),

  /**
   * Specify if the currently selected value is invalid.
   */
  invalid: PropTypes.bool,

  /**
   * Message which is displayed if the value is invalid.
   */
  invalidText: PropTypes.node,

  /**
   * Optional function to render items as custom components instead of strings.
   * Defaults to null and is overriden by a getter
   */
  itemToElement: PropTypes.func,

  /**
   * Helper function passed to downshift that allows the library to render a
   * given item to a string label. By default, it extracts the `label` field
   * from a given item to serve as the item label in the list
   */
  itemToString: PropTypes.func,

  /**
   * We try to stay as generic as possible here to allow individuals to pass
   * in a collection of whatever kind of data structure they prefer
   */
  items: PropTypes.array.isRequired,

  /**
   * should use "light theme" (white background)?
   */
  light: PropTypes.bool,

  /**
   * `onChange` is a utility for this controlled component to communicate to a
   * consuming component when a specific dropdown item is selected.
   * @param {{ selectedItem }}
   */
  onChange: PropTypes.func.isRequired,

  /**
   * Callback function to notify consumer when the text input changes.
   * This provides support to change available items based on the text.
   * @param {string} inputText
   */
  onInputChange: PropTypes.func,

  /**
   * Callback function that fires when the combobox menu toggle is clicked
   * @param {MouseEvent} event
   */
  onToggleClick: PropTypes.func,

  /**
   * Used to provide a placeholder text node before a user enters any input.
   * This is only present if the control has no items selected
   */
  placeholder: PropTypes.string.isRequired,

  /**
   * For full control of the selection
   */
  selectedItem: PropTypes.oneOfType([PropTypes.object, PropTypes.string]),

  /**
   * Specify your own filtering logic by passing in a `shouldFilterItem`
   * function that takes in the current input and an item and passes back
   * whether or not the item should be filtered.
   */
  shouldFilterItem: PropTypes.func,

  /**
   * Specify the size of the ListBox. Currently supports either `sm`, `md` or `lg` as an option.
   */
  size: ListBoxPropTypes.ListBoxSize,

  /**
   * Provide text to be used in a `<label>` element that is tied to the
   * combobox via ARIA attributes.
   */
  titleText: PropTypes.node,

  /**
   * Specify a custom translation function that takes in a message identifier
   * and returns the localized string for the message
   */
  translateWithId: PropTypes.func,

  /**
   * Currently supports either the default type, or an inline variant
   */
  type: ListBoxPropTypes.ListBoxType,

  /**
   * Specify whether the control is currently in warning state
   */
  warn: PropTypes.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: PropTypes.node
};
ComboBox.defaultProps = {
  disabled: false,
  itemToString: defaultItemToString,
  itemToElement: null,
  shouldFilterItem: defaultShouldFilterItem,
  type: 'default',
  ariaLabel: 'Choose an item',
  light: false,
  direction: 'bottom'
};
export default ComboBox;