function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, text, number } from '@storybook/addon-knobs';
import CodeSnippet from '../CodeSnippet';
import CodeSnippetSkeleton from './CodeSnippet.Skeleton';
import mdx from './CodeSnippet.mdx';
export default {
  title: 'Components/CodeSnippet',
  component: CodeSnippet,
  decorators: [withKnobs],
  parameters: {
    docs: {
      page: mdx
    },
    knobs: {
      escapeHTML: false
    }
  }
};
var multiSnippet = "\"scripts\": {\n    \"build\": \"lerna run build --stream --prefix --npm-client yarn\",\n    \"ci-check\": \"carbon-cli ci-check\",\n    \"clean\": \"lerna run clean && lerna clean --yes && rimraf node_modules\",\n    \"doctoc\": \"doctoc --title '## Table of Contents'\",\n    \"format\": \"prettier --write '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**'\",\n    \"format:diff\": \"prettier --list-different '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**' '!packages/components/**'\",\n    \"lint\": \"eslint actions config codemods packages\",\n    \"lint:styles\": \"stylelint '**/*.{css,scss}' --report-needless-disables --report-invalid-scope-disables\",\n    \"sync\": \"carbon-cli sync\",\n    \"test\": \"cross-env BABEL_ENV=test jest\",\n    \"test:e2e\": \"cross-env BABEL_ENV=test jest --testPathPattern=e2e --testPathIgnorePatterns='examples,/packages/components/,/packages/react/'\"\n  },\n  \"resolutions\": {\n    \"react\": \"~16.9.0\",\n    \"react-dom\": \"~16.9.0\",\n    \"react-is\": \"~16.9.0\",\n    \"react-test-renderer\": \"~16.9.0\"\n  },\n  \"devDependencies\": {\n    \"@babel/core\": \"^7.10.0\",\n    \"@babel/plugin-proposal-class-properties\": \"^7.7.4\",\n    \"@babel/plugin-proposal-export-default-from\": \"^7.7.4\",\n    \"@babel/plugin-proposal-export-namespace-from\": \"^7.7.4\",\n    \"@babel/plugin-transform-runtime\": \"^7.10.0\",\n    \"@babel/preset-env\": \"^7.10.0\",\n    \"@babel/preset-react\": \"^7.10.0\",\n    \"@babel/runtime\": \"^7.10.0\",\n    \"@commitlint/cli\": \"^8.3.5\",";
var shortSnippet = "yarn add carbon-components@latest carbon-components-react@latest @carbon/icons-react@latest carbon-icons@latest";
var inlineSnippet = "node -v";

var snippetText = function snippetText() {
  return {
    inline: text('Text to be displayed in the inline CodeSnippet', inlineSnippet),
    single: text('Text to be displayed in the single-line CodeSnippet', shortSnippet),
    multi: text('Text to be displayed in the multi-line CodeSnippet', multiSnippet)
  };
};

var props = function props() {
  return {
    disabled: boolean('Disabled (disabled)', false),
    light: boolean('Light variant (light)', false),
    feedback: text('Feedback text (feedback)', 'Copied'),
    feedbackTimeout: number('Feedback text timeout (feedbackTimeout)', 2000),
    showMoreText: text('Text for "show more" button (showMoreText)', 'Show more'),
    showLessText: text('Text for "show less" button (showLessText)', 'Show less'),
    hideCopyButton: boolean('Hide copy button (hideCopyButton)', false),
    onClick: action('onClick'),
    copyButtonDescription: text('Copy button title (copyButtonDescription)', 'Copy code snippet'),
    ariaLabel: text('ARIA label (ariaLabel)', 'Container label'),
    wrapText: boolean('Wrap text (wrapText)', true),
    maxCollapsedNumberOfRows: number('Maximum number of rows to be shown when collapsed (maxCollapsedNumberOfRows)', 15),
    maxExpandedNumberOfRows: number('Maximum number of rows to be shown when expanded (maxExpandedNumberOfRows)', 0),
    minCollapsedNumberOfRows: number('Minimum number of rows to be shown when collapsed (minCollapsedNumberOfRows)', 3),
    minExpandedNumberOfRows: number('Minimum number of rows to be shown when expanded (minExpandedNumberOfRows)', 16)
  };
};

export var inline = function inline() {
  return /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "inline",
    feedback: "Copied to clipboard"
  }, 'node -v');
};
export var multiline = function multiline() {
  return /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "multi",
    feedback: "Copied to clipboard"
  }, "  \"scripts\": {\n    \"build\": \"lerna run build --stream --prefix --npm-client yarn\",\n    \"ci-check\": \"carbon-cli ci-check\",\n    \"clean\": \"lerna run clean && lerna clean --yes && rimraf node_modules\",\n    \"doctoc\": \"doctoc --title '## Table of Contents'\",\n    \"format\": \"prettier --write '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**'\",\n    \"format:diff\": \"prettier --list-different '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**' '!packages/components/**'\",\n    \"lint\": \"eslint actions config codemods packages\",\n    \"lint:styles\": \"stylelint '**/*.{css,scss}' --report-needless-disables --report-invalid-scope-disables\",\n    \"sync\": \"carbon-cli sync\",\n    \"test\": \"cross-env BABEL_ENV=test jest\",\n    \"test:e2e\": \"cross-env BABEL_ENV=test jest --testPathPattern=e2e --testPathIgnorePatterns='examples,/packages/components/,/packages/react/'\"\n  },\n  \"resolutions\": {\n    \"react\": \"~16.9.0\",\n    \"react-dom\": \"~16.9.0\",\n    \"react-is\": \"~16.9.0\",\n    \"react-test-renderer\": \"~16.9.0\"\n  },\n  \"devDependencies\": {\n    \"@babel/core\": \"^7.10.0\",\n    \"@babel/plugin-proposal-class-properties\": \"^7.7.4\",\n    \"@babel/plugin-proposal-export-default-from\": \"^7.7.4\",\n    \"@babel/plugin-proposal-export-namespace-from\": \"^7.7.4\",\n    \"@babel/plugin-transform-runtime\": \"^7.10.0\",\n    \"@babel/preset-env\": \"^7.10.0\",\n    \"@babel/preset-react\": \"^7.10.0\",\n    \"@babel/runtime\": \"^7.10.0\",\n    \"@commitlint/cli\": \"^8.3.5\",");
};
export var singleline = function singleline() {
  return /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "single",
    feedback: "Copied to clipboard"
  }, "yarn add carbon-components@latest carbon-components-react@latest @carbon/icons-react@latest carbon-icons@latest");
};
export var skeleton = function skeleton() {
  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(CodeSnippetSkeleton, {
    type: "single",
    style: {
      marginBottom: 8
    }
  }), /*#__PURE__*/React.createElement(CodeSnippetSkeleton, {
    type: "multi"
  }));
};
var lightPropMessage = /*#__PURE__*/React.createElement("small", {
  style: {
    display: 'block',
    paddingBottom: '1rem'
  }
}, "The snippet container should never be the same color as the page background.", /*#__PURE__*/React.createElement("br", null), 'Do not use the ', /*#__PURE__*/React.createElement(CodeSnippet, {
  type: "inline",
  light: true
}, "light"), ' variant on ', /*#__PURE__*/React.createElement(CodeSnippet, {
  type: "inline",
  light: true
}, "$ui-background"), ' or ', /*#__PURE__*/React.createElement(CodeSnippet, {
  type: "inline",
  light: true
}, "$ui-02"), ".");
export var playground = function playground() {
  return /*#__PURE__*/React.createElement("div", {
    className: props().light ? 'bx--tile' : ''
  }, props().light && lightPropMessage, /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("h4", null, "Inline snippet"), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(CodeSnippet, _extends({
    type: "inline"
  }, props()), snippetText().inline), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("h4", null, "Single-line snippet"), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(CodeSnippet, _extends({
    type: "single"
  }, props()), snippetText().single), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("h4", null, "Multi-line snippet"), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(CodeSnippet, _extends({
    type: "multi"
  }, props()), snippetText().multi));
};