function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';
import { useFeatureFlag } from '../FeatureFlags';
import { settings } from 'carbon-components';
var prefix = settings.prefix;
var Checkbox = /*#__PURE__*/React.forwardRef(function Checkbox(_ref, _ref2) {
  var className = _ref.className,
      id = _ref.id,
      labelText = _ref.labelText,
      _onChange = _ref.onChange,
      indeterminate = _ref.indeterminate,
      hideLabel = _ref.hideLabel,
      wrapperClassName = _ref.wrapperClassName,
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? '' : _ref$title,
      other = _objectWithoutProperties(_ref, ["className", "id", "labelText", "onChange", "indeterminate", "hideLabel", "wrapperClassName", "title"]);

  var labelClasses = classNames("".concat(prefix, "--checkbox-label"), className);
  var innerLabelClasses = classNames("".concat(prefix, "--checkbox-label-text"), _defineProperty({}, "".concat(prefix, "--visually-hidden"), hideLabel));
  var wrapperClasses = classNames("".concat(prefix, "--form-item"), "".concat(prefix, "--checkbox-wrapper"), wrapperClassName);
  var enabled = useFeatureFlag('enable-v11-release');
  return /*#__PURE__*/React.createElement("div", {
    className: wrapperClasses
  }, /*#__PURE__*/React.createElement("input", _extends({}, other, {
    type: "checkbox",
    onChange: function onChange(evt) {
      if (enabled) {
        _onChange(evt, {
          checked: evt.target.checked,
          id: id
        });
      } else {
        _onChange(evt.target.checked, id, evt);
      }
    },
    className: "".concat(prefix, "--checkbox"),
    id: id,
    ref: function ref(el) {
      if (el) {
        el.indeterminate = indeterminate;
      }

      if (typeof _ref2 === 'function') {
        _ref2(el);
      } else if (Object(_ref2) === _ref2) {
        _ref2.current = el;
      }
    }
  })), /*#__PURE__*/React.createElement("label", {
    htmlFor: id,
    className: labelClasses,
    title: title || null
  }, /*#__PURE__*/React.createElement("span", {
    className: innerLabelClasses
  }, labelText)));
});
Checkbox.propTypes = {
  /**
   * Specify whether the underlying input should be checked
   */
  checked: PropTypes.bool,

  /**
   * Specify an optional className to be applied to the <label> node
   */
  className: PropTypes.string,

  /**
   * Specify whether the underlying input should be checked by default
   */
  defaultChecked: PropTypes.bool,

  /**
   * Specify whether the Checkbox should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: PropTypes.bool,

  /**
   * Provide an `id` to uniquely identify the Checkbox input
   */
  id: PropTypes.string.isRequired,

  /**
   * Specify whether the Checkbox is in an indeterminate state
   */
  indeterminate: PropTypes.bool,

  /**
   * Provide a label to provide a description of the Checkbox input that you are
   * exposing to the user
   */
  labelText: PropTypes.node.isRequired,

  /**
   * Receives three arguments: true/false, the checkbox's id, and the dom event.
   * `(value, id, event) => console.log({value, id, event})`
   */
  onChange: PropTypes.func,

  /**
   * Specify a title for the <label> node for the Checkbox
   */
  title: PropTypes.string,

  /**
   * The CSS class name to be placed on the wrapping element
   */
  wrapperClassName: PropTypes.string
};
Checkbox.defaultProps = {
  onChange: function onChange() {},
  indeterminate: false
};
Checkbox.displayName = 'Checkbox';
export default Checkbox;