function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import classNames from 'classnames';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, text } from '@storybook/addon-knobs';
import Checkbox from '../Checkbox';
import CheckboxSkeleton from '../Checkbox/Checkbox.Skeleton';
import { settings } from 'carbon-components';
import mdx from './Checkbox.mdx';
import { FeatureFlags } from '../FeatureFlags';
var prefix = settings.prefix;
export default {
  title: 'Components/Checkbox',
  component: Checkbox,
  subcomponents: {
    CheckboxSkeleton: CheckboxSkeleton
  },
  decorators: [withKnobs],
  parameters: {
    docs: {
      page: mdx
    }
  }
};
export var checkbox = function checkbox() {
  return /*#__PURE__*/React.createElement("fieldset", {
    className: "".concat(prefix, "--fieldset")
  }, /*#__PURE__*/React.createElement("legend", {
    className: "".concat(prefix, "--label")
  }, "Checkbox heading"), /*#__PURE__*/React.createElement(Checkbox, {
    labelText: "Checkbox label",
    id: "checkbox-label-1"
  }), /*#__PURE__*/React.createElement(Checkbox, {
    labelText: "Checkbox label",
    id: "checkbox-label-2"
  }));
};
export var unstable_Checkbox = function unstable_Checkbox() {
  return /*#__PURE__*/React.createElement(FeatureFlags, {
    flags: {
      'enable-v11-release': true
    }
  }, /*#__PURE__*/React.createElement("fieldset", {
    className: "".concat(prefix, "--fieldset")
  }, /*#__PURE__*/React.createElement("legend", {
    className: "".concat(prefix, "--label")
  }, "Checkbox heading"), /*#__PURE__*/React.createElement(Checkbox, _extends({}, props(), {
    labelText: "Checkbox label",
    id: "checkbox-label-1"
  })), /*#__PURE__*/React.createElement(Checkbox, _extends({}, props(), {
    labelText: "Checkbox label",
    id: "checkbox-label-2"
  }))));
};
unstable_Checkbox.story = {
  name: 'unstable_Checkbox'
};
export var skeleton = function skeleton() {
  return /*#__PURE__*/React.createElement(CheckboxSkeleton, null);
};

var props = function props() {
  return {
    checked: boolean('Checked (checked)', false),
    className: 'some-class',
    labelText: text('Label text (labelText)', 'Checkbox label'),
    indeterminate: boolean('Intermediate (indeterminate)', false),
    disabled: boolean('Disabled (disabled)', false),
    hideLabel: boolean('No label (hideLabel)', false),
    wrapperClassName: text('Wrapper CSS class name (wrapperClassName)', ''),
    onChange: action('onChange')
  };
};

export var playground = function playground() {
  return /*#__PURE__*/React.createElement("fieldset", {
    className: "".concat(prefix, "--fieldset")
  }, /*#__PURE__*/React.createElement("legend", {
    className: classNames("".concat(prefix, "--label"), _defineProperty({}, "".concat(prefix, "--label--disabled"), props().disabled))
  }, "Checkbox heading"), /*#__PURE__*/React.createElement(Checkbox, _extends({}, props(), {
    id: "checkbox-label-1"
  })), /*#__PURE__*/React.createElement(Checkbox, _extends({}, props(), {
    id: "checkbox-label-2"
  })));
};