/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import './AspectRatio-story.scss';
import { withKnobs, select } from '@storybook/addon-knobs';
import React from 'react';
import { Grid, Row, Column } from '../Grid';
import { AspectRatio } from './';
import mdx from './AspectRatio.mdx';
export default {
  title: 'Components/AspectRatio',
  component: AspectRatio,
  decorators: [withKnobs, function (story) {
    return /*#__PURE__*/React.createElement("div", {
      className: "aspect-ratio-story"
    }, story());
  }],
  parameters: {
    docs: {
      page: mdx
    }
  }
};
export var aspectRatio = function aspectRatio() {
  return /*#__PURE__*/React.createElement(Grid, null, /*#__PURE__*/React.createElement(Row, null, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(AspectRatio, {
    ratio: "1x1"
  }, "Content")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(AspectRatio, {
    ratio: "1x1"
  }, "Content")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(AspectRatio, {
    ratio: "1x1"
  }, "Content")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(AspectRatio, {
    ratio: "1x1"
  }, "Content"))));
};
export var playground = function playground() {
  var ratio = select('ratio', ['16x9', '9x16', '2x1', '1x2', '4x3', '3x4', '1x1'], '1x1');
  return /*#__PURE__*/React.createElement(Grid, null, /*#__PURE__*/React.createElement(Row, null, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(AspectRatio, {
    ratio: ratio
  }, "Content")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(AspectRatio, {
    ratio: ratio
  }, "Content")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(AspectRatio, {
    ratio: ratio
  }, "Content")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(AspectRatio, {
    ratio: ratio
  }, "Content"))));
};