function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, number, select, text } from '@storybook/addon-knobs';
import { default as Accordion, AccordionItem, AccordionSkeleton } from '../Accordion';
import Button from '../Button';
import mdx from './Accordion.mdx';
export default {
  title: 'Components/Accordion',
  component: Accordion,
  subcomponents: {
    AccordionItem: AccordionItem,
    AccordionSkeleton: AccordionSkeleton
  },
  decorators: [withKnobs],
  parameters: {
    docs: {
      page: mdx
    }
  }
};
export var accordion = function accordion() {
  return /*#__PURE__*/React.createElement(Accordion, null, /*#__PURE__*/React.createElement(AccordionItem, {
    title: "Section 1 title"
  }, /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")), /*#__PURE__*/React.createElement(AccordionItem, {
    title: "Section 2 title"
  }, /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")), /*#__PURE__*/React.createElement(AccordionItem, {
    title: "Section 3 title"
  }, /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")), /*#__PURE__*/React.createElement(AccordionItem, {
    title: "Section 4 title"
  }, /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")));
};
export var skeleton = function skeleton() {
  return /*#__PURE__*/React.createElement(AccordionSkeleton, {
    open: true,
    count: 4
  });
};
skeleton.decorators = [function (story) {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: '500px'
    }
  }, story());
}];
var props = {
  onClick: action('onClick'),
  onHeadingClick: action('onHeadingClick')
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
export var playground = function playground() {
  return /*#__PURE__*/React.createElement(Accordion, {
    disabled: boolean('Disable entire Accordion (disabled)', false),
    size: select('Accordion heading size (size)', sizes, undefined) || undefined,
    align: select('Accordion heading alignment (align)', ['start', 'end'], 'end')
  }, /*#__PURE__*/React.createElement(AccordionItem, _extends({
    title: text('The title (title)', 'Section 1 title'),
    open: boolean('Open the section (open)', false)
  }, props), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")), /*#__PURE__*/React.createElement(AccordionItem, _extends({
    title: "Section 2 title"
  }, props), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")), /*#__PURE__*/React.createElement(AccordionItem, _extends({
    title: "Section 3 title"
  }, props, {
    disabled: boolean('Disable Section 3 (disabled)', true)
  }), /*#__PURE__*/React.createElement(Button, null, "This is a button.")), /*#__PURE__*/React.createElement(AccordionItem, _extends({
    title: /*#__PURE__*/React.createElement("span", null, "Section 4 title (", /*#__PURE__*/React.createElement("em", null, "the title can be a node"), ")")
  }, props), /*#__PURE__*/React.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")));
};
export var skeletonPlayground = function skeletonPlayground() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: '500px'
    }
  }, /*#__PURE__*/React.createElement(AccordionSkeleton, {
    align: select('Accordion heading alignment (align)', ['start', 'end'], 'end'),
    open: boolean('Show first item opened (open)', true),
    count: number('Set number of items (count)', 4)
  }));
};