var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import lodash from 'lodash';
import strings from '../util/i18n';
import HTTPClient from './HTTPClient';
import renderReact from '../util/renderReact';
import { convertStringToQuery } from '../util/search-helper';
import { usage } from './helpfiles/savedsearchhelp';
import { SEARCH_QUERY_COUNT, SAVED_SEARCH_QUERY } from '../definitions/search-queries';
import { renderSearchAvailable } from './search';
import { getPluginState, resourceNotFound } from '../pluginState';
export function getQueryCount(searches) {
    const input = [...searches.map(query => convertStringToQuery(query.searchText))];
    return HTTPClient('post', 'search', SEARCH_QUERY_COUNT(input)).then(res => {
        return res.data.searchResult.map((query, idx) => {
            return Object.assign(Object.assign(Object.assign({}, query), { kind: 'savedSearches' }), searches[idx]);
        });
    });
}
export const doSavedSearch = args => new Promise(resolve => {
    const { argv } = args;
    const flags = getPluginState().flags;
    if (flags.includes(argv[1])) {
        resolve(usage());
    }
    else if (argv.length > 1) {
        const str = `${strings('validation.error')}:\t${strings('validation.savedsearches.parameters')}.\n${strings('validation.usage')}:\t${strings('validation.definition.savedsearches')}`;
        resolve(resourceNotFound(str));
    }
    const buildTable = (data) => __awaiter(void 0, void 0, void 0, function* () {
        const results = yield getQueryCount(data.items);
        const node = document.createElement('div', { is: 'react-entry-point' });
        node.classList.add('search-kui-plugin');
        return renderReact(results, node, args.command);
    });
    HTTPClient('post', 'search', SAVED_SEARCH_QUERY)
        .then(res => {
        const data = lodash.get(res, 'data', '');
        resolve(data.items.length > 0 ? buildTable(data) : resourceNotFound());
    })
        .catch(err => {
        resolve(renderSearchAvailable());
    });
});
export default (commandTree) => __awaiter(void 0, void 0, void 0, function* () {
    const cmd = commandTree.listen(`/savedsearches`, doSavedSearch);
    commandTree.synonym('/ss', doSavedSearch, cmd);
});
//# sourceMappingURL=savedSearch.js.map