"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderReact;

var _react = _interopRequireDefault(require("react"));

var _ResourceTable = _interopRequireDefault(require("../components/ResourceTable"));

var _core = require("@kui-shell/core");

var _i18n = _interopRequireDefault(require("./i18n"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function renderReact(data, node, command, wrapperClassName) {
  const uniqueKinds = [...new Set(data.items ? data.items.map(item => item.kind) : data.map(item => item.kind))];

  const searchResource = () => {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: wrapperClassName
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: 'search--resource'
    }, data.related && data.related.length > 0 && command.includes(':') ? /*#__PURE__*/_react.default.createElement("div", {
      className: 'related--resource-table-header'
    }, /*#__PURE__*/_react.default.createElement("button", {
      onClick: () => {
        console.log('button', command);
        (0, _core.pexecInCurrentTab)(`split --ifnot is-split --cmdline "${command.concat(' --related')}"`, undefined, false, true);
      },
      className: 'related--resource-table-header-button'
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: 'linked-resources'
    }, (0, _i18n.default)('search.label.view.related')), /*#__PURE__*/_react.default.createElement("span", {
      className: 'arrow-right'
    }, "\u2192"))) : null, uniqueKinds.map(kind => /*#__PURE__*/_react.default.createElement("div", {
      className: 'search--resource-table',
      key: kind.toString()
    }, /*#__PURE__*/_react.default.createElement(_ResourceTable.default, {
      items: data.items ? data.items.filter(item => item.kind === kind) : data.filter(item => item.kind === kind),
      kind: kind.toString()
    })))));
  };

  return {
    react: /*#__PURE__*/_react.default.createElement(searchResource)
  };
}