"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@kui-shell/core");

var _config = _interopRequireDefault(require("./lib/shared/config"));

var _HTTPClient = _interopRequireDefault(require("./controller/HTTPClient"));

var _pluginState = require("./pluginState");

var _lodash = _interopRequireDefault(require("lodash"));

var _searchQueries = require("./definitions/search-queries");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const registerCapability = () => __awaiter(void 0, void 0, void 0, function* () {
  if ((0, _core.inBrowser)() && (yield (0, _config.default)()).env !== 'development') {
    yield fetch('/search').then(page => page.text()).then(data => {
      const dom = new DOMParser().parseFromString(data, 'text/html');
      const metaTag = dom.body.querySelector('meta[name=csrf-token]');
      const token = (metaTag === null || metaTag === void 0 ? void 0 : metaTag.content) || '';
      let meta = document.createElement('meta');
      meta.setAttribute('name', 'csrf-token');
      meta.setAttribute('content', token);
      document.body.appendChild(meta);
    });
  }

  (0, _HTTPClient.default)('post', 'search', _searchQueries.GET_SEARCH_SCHEMA).then(resp => {
    (0, _pluginState.setPluginState)('searchSchema', _lodash.default.get(resp, 'data.searchSchema.allProperties', ''));
  });
});

var _default = registerCapability;
exports.default = _default;