"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setPluginState = exports.getPluginState = exports.resourceNotFound = void 0;

var _i18n = _interopRequireDefault(require("./util/i18n"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const state = {
  default: ['cluster', 'kind', 'label', 'name', 'namespace', 'status'],
  flags: ['-h', '--h', '-help', '--help'],
  searchSchema: []
};

const getPluginState = () => {
  return state;
};

exports.getPluginState = getPluginState;

const setPluginState = (key, value) => {
  state[key] = value;
};

exports.setPluginState = setPluginState;

const resourceNotFound = text => {
  const node = document.createElement('pre');
  node.setAttribute('class', 'oops');
  node.innerText = !text ? (0, _i18n.default)('search.no.resources.found') : text;
  return node;
};

exports.resourceNotFound = resourceNotFound;