/*
Copyright 2017 Google Inc. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
	http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package main

import (
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"

	"github.com/google/go-jsonnet/internal/dump"
	"github.com/google/go-jsonnet/internal/program"
)

func main() {
	if len(os.Args) != 2 {
		fmt.Fprintf(os.Stderr, "usage: %s <file>\n", filepath.Base(os.Args[0]))
		os.Exit(2)
	}
	buf, err := ioutil.ReadFile(os.Args[1])
	if err != nil {
		panic(err)
	}

	node, err := program.SnippetToAST("<std>", string(buf))
	if err != nil {
		panic(err)
	}

	dump.Config.HidePrivateFields = false
	dump.Config.VariableName = "StdAst"
	dump.Config.VariableDescription = "StdAst is the AST for the standard library."
	ast := dump.Sdump(node)

	dst := os.Stdout
	dst.WriteString(header)
	dst.WriteString(ast)
}

var header = `
///////////////////////////////////////////////////////////
// This file was auto-generated by cmd/dumpstdlibast.go. //
// https://github.com/google/go-jsonnet#generated-stdlib //
//                                                       //
// --------------- DO NOT EDIT BY HAND! ---------------  //
///////////////////////////////////////////////////////////

package astgen

import (
	"github.com/google/go-jsonnet/ast"
)

`[1:]
