---
id: Form
section: components
cssPrefix: pf-c-form
---## Examples

### Vertically aligned labels

```html
<form novalidate class="pf-c-form">
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label" for="vertical-align-labels-form-name">
        <span class="pf-c-form__label-text">Name</span>
        <span class="pf-c-form__label-required" aria-hidden="true">&#42;</span>
      </label>
      <button class="pf-c-form__group-label-help" aria-label="More info">
        <i class="pficon pf-icon-help" aria-hidden="true"></i>
      </button>
    </div>
    <div class="pf-c-form__group-control">
      <input class="pf-c-form-control" type="text" id="vertical-align-labels-form-name" name="vertical-align-labels-form-name" required />
    </div>
  </div>
</form>
```

### Horizontally aligned labels

```html
<form novalidate class="pf-c-form pf-m-horizontal">
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label" for="horizontal-align-labels-1-form-name">
        <span class="pf-c-form__label-text">Name</span>
        <span class="pf-c-form__label-required" aria-hidden="true">&#42;</span>
      </label>
    </div>
    <div class="pf-c-form__group-control">
      <input class="pf-c-form-control" type="text" id="horizontal-align-labels-1-form-name" name="horizontal-align-labels-1-form-name" required />
    </div>
  </div>
</form>
<br />
<form novalidate class="pf-c-form pf-m-horizontal">
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label" for="horizontal-align-labels-2-form-name">
        <span class="pf-c-form__label-text">Information</span>
      </label>
      <button class="pf-c-form__group-label-help" aria-label="More info">
        <i class="pficon pf-icon-help" aria-hidden="true"></i>
      </button>
    </div>
    <div class="pf-c-form__group-control">
      <textarea class="pf-c-form-control" type="text" id="horizontal-align-labels-2-form-name-2" name="horizontal-align-labels-2-form-name-2" aria-label="textarea example"></textarea>
    </div>
  </div>
</form>
<br />
<form novalidate class="pf-c-form pf-m-horizontal">
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label pf-m-no-padding-top">
      <label class="pf-c-form__label" for="horizontal-align-labels-top-form-name">
        <span class="pf-c-form__label-text">Label (no top padding)</span>
      </label>
      <button class="pf-c-form__group-label-help" aria-label="More info">
        <i class="pficon pf-icon-help" aria-hidden="true"></i>
      </button>
    </div>
    <div class="pf-c-form__group-control">
      <div class="pf-c-check">
        <input class="pf-c-check__input" type="checkbox" type="checkbox" id="alt-form-checkbox1" name="alt-form-checkbox1" />
        <label class="pf-c-check__label" for="alt-form-checkbox1">Option 1</label>
      </div>
      <div class="pf-c-check">
        <input class="pf-c-check__input" type="checkbox" type="checkbox" id="alt-form-checkbox2" name="alt-form-checkbox2" />
        <label class="pf-c-check__label" for="alt-form-checkbox2">Option 2</label>
      </div>
    </div>
  </div>
</form>
```

### Form sections

```html
<form novalidate class="pf-c-form">
  <section class="pf-c-form__section">
    <div class="pf-c-form__group">
      <div class="pf-c-form__group-label">
        <label class="pf-c-form__label" for="form-section-example-form-section-1-input">
          <span class="pf-c-form__label-text">Form section 1 inputs</span>
        </label>
      </div>
      <div class="pf-c-form__group-control">
        <input class="pf-c-form-control" type="text" id="form-section-example-form-section-1-input" name="form-section-example-form-section-1-input" required />
      </div>
    </div>
  </section>
  <section class="pf-c-form__section">
    <div class="pf-c-form__group">
      <div class="pf-c-form__group-label">
        <label class="pf-c-form__label" for="form-section-example-form-section-2-input">
          <span class="pf-c-form__label-text">Form section 2 inputs</span>
        </label>
      </div>
      <div class="pf-c-form__group-control">
        <input class="pf-c-form-control" type="text" id="form-section-example-form-section-2-input" name="form-section-example-form-section-2-input" required />
      </div>
    </div>
  </section>
</form>
```

### Help text

```html
<form novalidate class="pf-c-form">
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label" for="help-text-form-name">
        <span class="pf-c-form__label-text">Name</span>
        <span class="pf-c-form__label-required" aria-hidden="true">&#42;</span>
      </label>
    </div>
    <div class="pf-c-form__group-control">
      <input class="pf-c-form-control" required type="text" id="help-text-form-name" name="help-text-form-name" aria-describedby="help-text-form-name-helper" />
      <p class="pf-c-form__helper-text" id="help-text-form-name-helper" aria-live="polite">This is helper text</p>
    </div>
  </div>
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label" for="help-text-form-email">
        <span class="pf-c-form__label-text">E-mail</span>
        <span class="pf-c-form__label-required" aria-hidden="true">&#42;</span>
      </label>
    </div>
    <div class="pf-c-form__group-control">
      <input class="pf-c-form-control pf-m-warning" required type="text" id="help-text-form-email" name="help-text-form-email" aria-describedby="help-text-form-email-helper" />
      <p class="pf-c-form__helper-text pf-m-warning" id="help-text-form-email-helper" aria-live="polite">This is helper text for a warning input</p>
    </div>
  </div>
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label" for="help-text-form-address">
        <span class="pf-c-form__label-text">Address</span>
        <span class="pf-c-form__label-required" aria-hidden="true">&#42;</span>
      </label>
    </div>
    <div class="pf-c-form__group-control">
      <input class="pf-c-form-control" required type="text" id="help-text-form-address" name="help-text-form-address" aria-invalid="true" aria-describedby="help-text-form-address-helper" />
      <p class="pf-c-form__helper-text pf-m-error" id="help-text-form-address-helper" aria-live="polite">This is helper text for an invalid input</p>
    </div>
  </div>
  <div class="pf-c-form__group">
    <div class="pf-c-form__group-label">
      <label class="pf-c-form__label" for="help-text-form-comment">
        <span class="pf-c-form__label-text">Comment</span>
      </label>
    </div>
    <div class="pf-c-form__group-control">
      <input class="pf-c-form-control pf-m-success" value="This is a valid comment"type="text" id="help-text-form-comment" name="help-text-form-comment" aria-describedby="help-text-form-comment-help" />
      <p class="pf-c-form__helper-text pf-m-success" id="help-text-form-comment-help" aria-live="polite">This is helper text for success input</p>
    </div>
  </div>
  <div class="pf-c-form__group">
    <label class="pf-c-form__label" for="help-text-simple-form-info">
      <span class="pf-c-form__label-text">Information</span>
    </label>
    <textarea class="pf-c-form-control" id="help-text-simple-form-info" name="help-text-simple-form-info" aria-invalid="true" aria-describedby="help-text-simple-form-info-helper"></textarea>
    <p class="pf-c-form__helper-text pf-m-error" id="help-text-simple-form-info-helper" aria-live="polite">
      <span class="pf-c-form__helper-text-icon">
        <i class="fas fa-exclamation-circle" aria-hidden="true"></i>
      </span>This is helper text with an icon.</p>
  </div>
</form>
```

### Action group

```html
<form novalidate class="pf-c-form">
  <div class="pf-c-form__group pf-m-action">
    <div class="pf-c-form__actions">
      <button class="pf-c-button pf-m-primary" type="submit">Submit form</button>
      <button class="pf-c-button pf-m-secondary" type="reset">Reset form</button>
    </div>
  </div>
</form>
```

## Documentation

### Accessibility

| Attribute                                                 | Applied to                                                     | Outcome                                                                                                                                                                                                                                                                                                                                                                |
| --------------------------------------------------------- | -------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `for`                                                     | `<label>`                                                      | Each `<label>` must have a `for` attribute that matches its form field id. **Required**                                                                                                                                                                                                                                                                                |
| `id`                                                      | `<input type="radio/checkbox/text">`, `<select>`, `<textarea>` | Each `<form>` field must have an `id` attribute that matches its label's `for` value. **Required**                                                                                                                                                                                                                                                                     |
| `required`                                                | `<input>`, `<select>`, `<textarea>`                            | Required fields must include these attributes.                                                                                                                                                                                                                                                                                                                         |
| `id="{helper_text_id}"`                                   | `.pf-c-form__helper-text`                                      | Form fields with related `.pf-c-form__helper-text` require this attribute. Usage `<p class="pf-c-form__helper-text" id="{helper_text_id}">`.                                                                                                                                                                                                                           |
| `aria-describedby="{helper_text_id}"`                     | `<input>`, `<select>`, `<textarea>`                            | Form fields with related `.pf-c-form__helper-text` require this attribute. Usage `<input aria-describedby="{helper_text_id}">`.                                                                                                                                                                                                                                        |
| `aria-invalid="true" aria-describedby="{helper_text_id}"` | `<input>`, `<select>`, `<textarea>`                            | When form validation fails `aria-describedby` is used to communicate the error to the user. These attributes need to be handled with Javascript so that `aria-describedby` only references help text that explains the error, and so that `aria-invalid="true"` is only present when validation fails. For proper styling of errors `aria-invalid="true"` is required. |
| `aria-hidden="true"`                                      | `.pf-c-form__label-required`                                   | Hides the required indicator from assistive technologies.                                                                                                                                                                                                                                                                                                              |

### Usage

| Class                          | Applied to                  | Outcome                                                                                                 |
| ------------------------------ | --------------------------- | ------------------------------------------------------------------------------------------------------- |
| `.pf-c-form`                   | `<form>`                    | Initiates a standard form. **Required**                                                                 |
| `.pf-c-form__section`          | `<div>, <section>`          | Initiates a form section.                                                                               |
| `.pf-c-form__group`            | `<div>`                     | Initiates a form group.                                                                                 |
| `.pf-c-form__group-label`      | `<div>`                     | Initiates a form group label.                                                                           |
| `.pf-c-form__label`            | `<label>`                   | Initiates a form label. **Required**                                                                    |
| `.pf-c-form__label-text`       | `<span>`                    | Initiates a form label text. **Required**                                                               |
| `.pf-c-form__label-required`   | `<span>`                    | Initiates a form label required indicator.                                                              |
| `.pf-c-form__group-label-help` | `<button>`                  | Initiates a field level help button.                                                                    |
| `.pf-c-form__group-control`    | `<div>`                     | Initiates a form group control section.                                                                 |
| `.pf-c-form__actions`          | `<div>`                     | Iniates a row of actions.                                                                               |
| `.pf-c-form__helper-text`      | `<p>`                       | Initiates a form helper text block.                                                                     |
| `.pf-c-form__helper-text-icon` | `<span>`                    | Initiates a form helper text icon.                                                                      |
| `.pf-c-form__alert`            | `<div>`                     | Initiates the form alert container for inline alerts.                                                   |
| `.pf-m-horizontal`             | `.pf-c-form`                | Modifies form for a horizontal layout.                                                                  |
| `.pf-m-action`                 | `.pf-c-form__group`         | Modifies form group margin-top.                                                                         |
| `.pf-m-success`                | `.pf-c-form__helper-text`   | Modifies text color of helper text for success state.                                                   |
| `.pf-m-warning`                | `.pf-c-form__helper-text`   | Modifies text color of helper text for warning state.                                                   |
| `.pf-m-error`                  | `.pf-c-form__helper-text`   | Modifies text color of helper text for error state.                                                     |
| `.pf-m-inactive`               | `.pf-c-form__helper-text`   | Modifies display of helper text to none.                                                                |
| `.pf-m-disabled`               | `.pf-c-form__label`         | Modifies form label to show disabled state.                                                             |
| `.pf-m-no-padding-top`         | `.pf-c-form__group-label`   | Removes top padding from the label element for labels adjacent to an element that isn't a form control. |
| `.pf-m-inline`                 | `.pf-c-form__group-control` | Modifies form group children to be inline (this is primarily for radio buttons and checkboxes).         |
