"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeViewList = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const react_styles_1 = require("@patternfly/react-styles");
const tree_view_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/TreeView/tree-view"));
const TreeViewSearch_1 = require("./TreeViewSearch");
const Divider_1 = require("../Divider");
exports.TreeViewList = (_a) => {
    var { isNested = false, onSearch, searchProps, children } = _a, props = tslib_1.__rest(_a, ["isNested", "onSearch", "searchProps", "children"]);
    const list = React.createElement("ul", { role: isNested ? 'group' : 'tree' }, children);
    return isNested ? (list) : (React.createElement("div", Object.assign({ className: react_styles_1.css(tree_view_1.default.treeView) }, props),
        onSearch && (React.createElement(React.Fragment, null,
            React.createElement(TreeViewSearch_1.TreeViewSearch, Object.assign({ onChange: onSearch }, searchProps)),
            React.createElement(Divider_1.Divider, null))),
        list));
};
exports.TreeViewList.displayName = 'TreeViewList';
//# sourceMappingURL=TreeViewList.js.map