"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const react_styles_1 = require("@patternfly/react-styles");
const table_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Table/table"));
const Table_1 = require("../../Table");
const SortColumn_1 = require("../../SortColumn");
exports.sortable = (label, { columnIndex, column, property }) => {
    const { extraParams: { sortBy, onSort } } = column;
    const extraData = {
        columnIndex,
        column,
        property
    };
    const isSortedBy = sortBy && columnIndex === sortBy.index;
    /**
     * @param {React.MouseEvent} event - React mouse event
     */
    function sortClicked(event) {
        let reversedDirection;
        if (!isSortedBy) {
            reversedDirection = Table_1.SortByDirection.asc;
        }
        else {
            reversedDirection = sortBy.direction === Table_1.SortByDirection.asc ? Table_1.SortByDirection.desc : Table_1.SortByDirection.asc;
        }
        // tslint:disable-next-line:no-unused-expression
        onSort && onSort(event, columnIndex, reversedDirection, extraData);
    }
    return {
        className: react_styles_1.css(table_1.default.tableSort, isSortedBy && table_1.default.modifiers.selected),
        'aria-sort': isSortedBy ? `${sortBy.direction}ending` : 'none',
        children: (React.createElement(SortColumn_1.SortColumn, { isSortedBy: isSortedBy, sortDirection: isSortedBy ? sortBy.direction : '', onSort: sortClicked }, label))
    };
};
//# sourceMappingURL=sortable.js.map