"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * merge-props.js
 *
 * Forked from reactabular-table version 8.14.0
 * https://github.com/reactabular/reactabular/tree/v8.14.0/packages/reactabular-table/src
 */
const lodash_1 = require("lodash");
const react_styles_1 = require("@patternfly/react-styles");
/**
 * @param {any} props - Props
 */
function mergeProps(...props) {
    const firstProps = props[0];
    const restProps = props.slice(1);
    if (!restProps.length) {
        return lodash_1.mergeWith({}, firstProps);
    }
    // Avoid mutating the first prop collection
    return lodash_1.mergeWith(lodash_1.mergeWith({}, firstProps), ...restProps, (a, b, key) => {
        if (key === 'children') {
            // Children have to be merged in reverse order for Reactabular
            // logic to work.
            return Object.assign(Object.assign({}, b), a);
        }
        if (key === 'className') {
            // Process class names through classNames to merge properly
            // as a string.
            return react_styles_1.css(a, b);
        }
        return undefined;
    });
}
exports.mergeProps = mergeProps;
//# sourceMappingURL=merge-props.js.map