import { __rest } from "tslib";
import * as React from 'react';
import AngleRightIcon from '@patternfly/react-icons/dist/js/icons/angle-right-icon';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/NotificationDrawer/notification-drawer';
import maxLines from '@patternfly/react-tokens/dist/js/c_notification_drawer__group_toggle_title_max_lines';
import { Badge } from '../Badge';
export const NotificationDrawerGroup = (_a) => {
    var { children, className = '', count, isExpanded, isRead = false, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onExpand = (event, expanded) => undefined, title, truncateTitle = 0 } = _a, props = __rest(_a, ["children", "className", "count", "isExpanded", "isRead", "onExpand", "title", "truncateTitle"]);
    const titleRef = React.useRef(null);
    React.useEffect(() => {
        if (!titleRef.current || !truncateTitle) {
            return;
        }
        titleRef.current.style.setProperty(maxLines.name, truncateTitle.toString());
    }, [titleRef, truncateTitle]);
    return (React.createElement("section", Object.assign({}, props, { className: css(styles.notificationDrawerGroup, isExpanded && styles.modifiers.expanded, className) }),
        React.createElement("h1", null,
            React.createElement("button", { className: css(styles.notificationDrawerGroupToggle), "aria-expanded": isExpanded, onClick: e => onExpand(e, !isExpanded), onKeyDown: e => {
                    if (e.key === 'Enter' || e.key === ' ') {
                        e.preventDefault();
                        onExpand(e, !isExpanded);
                    }
                } },
                React.createElement("div", { ref: titleRef, className: css(styles.notificationDrawerGroupToggleTitle) }, title),
                React.createElement("div", { className: css(styles.notificationDrawerGroupToggleCount) },
                    React.createElement(Badge, { isRead: isRead }, count)),
                React.createElement("span", { className: "pf-c-notification-drawer__group-toggle-icon" },
                    React.createElement(AngleRightIcon, null)))),
        children));
};
NotificationDrawerGroup.displayName = 'NotificationDrawerGroup';
//# sourceMappingURL=NotificationDrawerGroup.js.map