---
id: 'Search input'
beta: true
section: components
cssPrefix: pf-c-search-input
---## Examples

### Basic

```html
<div class="pf-c-search-input">
  <span class="pf-c-search-input__text">
    <span class="pf-c-search-input__icon">
      <i class="fas fa-search fa-fw" aria-hidden="true"></i>
    </span>
    <input class="pf-c-search-input__text-input" type="text" placeholder="Find by name" aria-label="Find by name" />
  </span>
</div>
```

### No match

```html
<div class="pf-c-search-input">
  <span class="pf-c-search-input__text">
    <span class="pf-c-search-input__icon">
      <i class="fas fa-search fa-fw" aria-hidden="true"></i>
    </span>
    <input class="pf-c-search-input__text-input" type="text" placeholder="Find by name" aria-label="Find by name" value="Joh" />
  </span>
  <span class="pf-c-search-input__utilities">
    <span class="pf-c-search-input__clear">
      <button class="pf-c-button pf-m-plain" type="button" aria-label="Clear">
        <i class="fas fa-times fa-fw" aria-hidden="true"></i>
      </button>
    </span>
  </span>
</div>
```

### Match with result count

```html
<div class="pf-c-search-input">
  <span class="pf-c-search-input__text">
    <span class="pf-c-search-input__icon">
      <i class="fas fa-search fa-fw" aria-hidden="true"></i>
    </span>
    <input class="pf-c-search-input__text-input" type="text" placeholder="Find by name" aria-label="Find by name" value="John Doe" />
  </span>
  <span class="pf-c-search-input__utilities">
    <span class="pf-c-search-input__count">
      <span class="pf-c-badge pf-m-read">3</span>
    </span>
    <span class="pf-c-search-input__clear">
      <button class="pf-c-button pf-m-plain" type="button" aria-label="Clear">
        <i class="fas fa-times fa-fw" aria-hidden="true"></i>
      </button>
    </span>
  </span>
</div>
```

### Match with navigable options

```html
<div class="pf-c-search-input">
  <span class="pf-c-search-input__text">
    <span class="pf-c-search-input__icon">
      <i class="fas fa-search fa-fw" aria-hidden="true"></i>
    </span>
    <input class="pf-c-search-input__text-input" type="text" placeholder="Find by name" aria-label="Find by name" value="John Doe" />
  </span>
  <span class="pf-c-search-input__utilities">
    <span class="pf-c-search-input__count">
      <span class="pf-c-badge pf-m-read">1 / 3</span>
    </span>
    <span class="pf-c-search-input__nav">
      <button class="pf-c-button pf-m-plain" type="button" disabled aria-label="Previous">
        <i class="fas fa-angle-down fa-fw" aria-hidden="true"></i>
      </button>
      <button class="pf-c-button pf-m-plain" type="button" aria-label="Next">
        <i class="fas fa-angle-up fa-fw" aria-hidden="true"></i>
      </button>
    </span>
    <span class="pf-c-search-input__clear">
      <button class="pf-c-button pf-m-plain" type="button" aria-label="Clear">
        <i class="fas fa-times fa-fw" aria-hidden="true"></i>
      </button>
    </span>
  </span>
</div>
```

### Accessibility

| Attributes                        | Applied to                                 | Outcome                                                                |
| --------------------------------- | ------------------------------------------ | ---------------------------------------------------------------------- |
| `aria-hidden="true"`              | `.pf-c-search-input__icon > *`             | Hides the search icon from assistive technologies. **Required**        |
| `aria-label="Previous"`           | `.pf-c-search-input__nav > .pf-c-button`   | Provides an accessible label for the previous nav button. **Required** |
| `aria-label="Next"`               | `.pf-c-search-input__nav > .pf-c-button`   | Provides an accessible label for the next nav button. **Required**     |
| `aria-label="[descriptive text]"` | `.pf-c-search-input__text-input`           | Provides an accessible label for the search input. **Required**        |
| `aria-label="Clear"`              | `.pf-c-search-input__clear > .pf-c-button` | Provides an accessible label for the clear button. **Required**        |

### Usage

| Class                            | Applied to | Outcome                                                                                   |
| -------------------------------- | ---------- | ----------------------------------------------------------------------------------------- |
| `.pf-c-search-input`             | `<div>`    | Initiates the custom search input component. **Required**                                 |
| `.pf-c-search-input__text`       | `<span>`   | Initiates the text area. **Required**                                                     |
| `.pf-c-search-input__text-input` | `<input>`  | Initiates the search input. **Required**                                                  |
| `.pf-c-search-input__icon`       | `<span>`   | Initiates the search icon container. **Required**                                         |
| `.pf-c-search-input__utilities`  | `<span>`   | Initiates the utilities area beside the search input.                                     |
| `.pf-c-search-input__count`      | `<span>`   | Initiates the item count container.                                                       |
| `.pf-c-search-input__nav`        | `<span>`   | Initiates the navigable buttons container.                                                |
| `.pf-c-search-input__clear`      | `<span>`   | Initiates the clear button container. **Required when there is text in the search input** |
