# Design Docs
Generally, design docs are on Google docs:

## Conventions
* [Versioning of Constraint Templates](https://docs.google.com/document/d/1vB_2wm60WCVLXoegMrupqwqKAuW6gbwEIxg3vBQj6cs/edit)

## In Development

## Proposed
* [ByPod Status Design](https://docs.google.com/document/d/13xmVQuE9Q8CFDpL9pzpoAyH1nIzHndP0OfccXVShiPo/edit?usp=sharing)
* [Namespace-Scoped Constraints](https://docs.google.com/document/d/1-pY7B5C6R0fjUbDu8izlcP7MSUDVDHv5XK16BFyTGRc/edit#heading=h.w8j68o8vjdts)
* [Mutation Design - 4th Edition (current approach)](https://docs.google.com/document/d/1MdchNFz9guycX__QMGxpJviPaT_MZs8iXaAFqCvoXYQ/edit?ts=5f73fb77#
)
   * [Mutation Interfaces (for the current approach)](https://docs.google.com/document/d/1c5Z3g6Zsfmga7xod4--t6RrXamdAaMaqYzPNujtZb10/edit)
   * [OPA Gatekeeper Mutation (alternate proposal)](https://docs.google.com/document/d/1LtNIxd-Y3oh0HPgPYdaVV7t2c6vBSwzYAFcTyxQYZjE/edit)
   * [Mutation Revised Design Doc (June 2019)](https://docs.google.com/document/d/1G7WgZKx1Y3VOTUjrqn7DjDaZgSKCIZowILm_I6psrw0/edit#heading=h.mtvdjag5uj9)
   * [Mutation Initial Design Doc (April 2019)](https://docs.google.com/document/d/1qTHwqoUX8AL2jodyWKB_2szrGDwhi14Ra_LlQ-ogtck/edit#heading=h.iu1ppjy7g7j)
* [External Data](https://docs.google.com/document/d/1hPi86jdsCKg8puYT5_s_73mPGExUJeZfyKmvG-XWtPc/edit#)
* [Gatekeeper v1beta1 CRD Deprecation](https://docs.google.com/document/d/12TD9vk79X3y0RgNxURamW4tQOyd6YjA6WrwDAqcplwg/edit#)

## Implemented
* [V3 Accepted Design](https://docs.google.com/document/d/1yC4wgpVoJj6ngYnSTtO-HeaIBl05gla562sD7qKPy3M/edit#heading=h.z0bjqzl81dpe)
   * [Initial v3 Design Proposal](https://docs.google.com/document/d/1S4C5BHZDoAqw5m5aVWrr8b8fe4H3I2jymmKitoTia2Y/edit#heading=h.p63jc1w6w88d)
   * [Initial v3 Design Proposal -- Detailed Design](https://docs.google.com/document/d/1oZR9b52z_EQkhit9A-ApFvz3tqsn9ckzvPyxKw1pBTo/edit)
* [Dynamic Watch Design for OPA/Gatekeeper](https://docs.google.com/document/d/1Wi3LM3sG6Qgfzm--bWb6R0SEKCkQCCt-ene6cO62FlM/edit)
* [Architecture Diagram](https://docs.google.com/document/d/1It-Mpz36ygqrElmh2hZ3DvDIqKYyKUZN6V4d7UTlEG8/edit#heading=h.rzuko1admjwd)
* [Audit Design Doc](https://docs.google.com/document/d/1EnVOOaLZ_fWxo02ZmgnvTE2PtTRbyyhKjioPe-_In28/edit)
* [Dry-Run Design Doc](https://docs.google.com/document/d/17nJDJxjY_XHV8zrMNdOi2hFgfm6XKGJi0QyznsbhQ70/edit#heading=h.z0bjqzl81dpe)
* [Constraint Framework Client Interface](https://docs.google.com/document/d/1NDOgu8F_yQqrxRRVTDiCXGXMsajA3Jtp-lwGrZsDFcI/edit#)
* [Logging Design Doc](https://docs.google.com/document/d/1ap7AKOupNcR_42s8mkSh5FV9eteXTd4VCqelKst73VY/edit)
* [Namespace Exclusion Design doc](https://docs.google.com/document/d/1yHuXFs_HQL5N9yT9QVi6AMyflWPtZS4Pg-uXczdqgZ8/edit?usp=sharing)
* [Metrics Design Issue](https://github.com/open-policy-agent/gatekeeper/issues/157#issuecomment-553015292)

## Roadmap (in development)
* See [milestones](https://github.com/open-policy-agent/gatekeeper/milestones?direction=asc&sort=due_date)

## Roadmap (complete)
* [GA Development Path](https://docs.google.com/document/d/1Lolr_jUkVlGSyk4iGhajx1LXWsWRXhLeu3L7s3lLDGY/edit#heading=h.9aae3wnhx5k3)
* [Post-MVP Features Doc](https://docs.google.com/document/d/1t61-fcFdbNA0o1kTQd-oS2rkaUsouN4Kg6ImW8agfbk/edit#heading=h.57n2tr53h5l)
* [MVP for Alpha](https://docs.google.com/document/d/1EPb3zg-hknAK7WqYh96XIXCEXG9mQqr_Cqn8VuEGoLI/edit#heading=h.vu8n6esi249)

## Discussions

These docs may not be design docs in themselves, but seek to influence design
decisions

* [Mutation Dynamics](https://docs.google.com/document/d/1WKj-9xYYVO9IckQVZHYVFCziRVS6zxCfvJxWbkbLcOM/view#)
   * A dissection of the mutation problem space, attempting to break down the
     salient behavioral elements and figure out what's needed for a
     user-friendly set of mutation primitives.
* [Mutation Transience](https://docs.google.com/document/d/1pyM3h5c8gh5W2eKP37qpge9jtEtRAs6Uv_sTyJttm3c/edit?ts=606f8bbf#)
   * Looking at how a mutation webhook may behave during configuration changes and discussing what that might mean in terms
     of necessary status fields and best practices for writing mutators.
* [Finalizers in OPA Gatekeeper](https://docs.google.com/document/d/1lZZsHACi4LnPF4bBvjfg0qpbYGChkZd6mhaaRnvkx6M/view#)
   * This doc discusses the impact the existence of finalizers has on running
     OPA Gatekeeper. Its points have either been addressed or are on track
     to being addressed.
