// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/api/config/v1"
	scheme "github.com/openshift/client-go/config/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// FeatureGatesGetter has a method to return a FeatureGateInterface.
// A group's client should implement this interface.
type FeatureGatesGetter interface {
	FeatureGates() FeatureGateInterface
}

// FeatureGateInterface has methods to work with FeatureGate resources.
type FeatureGateInterface interface {
	Create(*v1.FeatureGate) (*v1.FeatureGate, error)
	Update(*v1.FeatureGate) (*v1.FeatureGate, error)
	UpdateStatus(*v1.FeatureGate) (*v1.FeatureGate, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.FeatureGate, error)
	List(opts metav1.ListOptions) (*v1.FeatureGateList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.FeatureGate, err error)
	FeatureGateExpansion
}

// featureGates implements FeatureGateInterface
type featureGates struct {
	client rest.Interface
}

// newFeatureGates returns a FeatureGates
func newFeatureGates(c *ConfigV1Client) *featureGates {
	return &featureGates{
		client: c.RESTClient(),
	}
}

// Get takes name of the featureGate, and returns the corresponding featureGate object, and an error if there is any.
func (c *featureGates) Get(name string, options metav1.GetOptions) (result *v1.FeatureGate, err error) {
	result = &v1.FeatureGate{}
	err = c.client.Get().
		Resource("featuregates").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of FeatureGates that match those selectors.
func (c *featureGates) List(opts metav1.ListOptions) (result *v1.FeatureGateList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.FeatureGateList{}
	err = c.client.Get().
		Resource("featuregates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested featureGates.
func (c *featureGates) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("featuregates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a featureGate and creates it.  Returns the server's representation of the featureGate, and an error, if there is any.
func (c *featureGates) Create(featureGate *v1.FeatureGate) (result *v1.FeatureGate, err error) {
	result = &v1.FeatureGate{}
	err = c.client.Post().
		Resource("featuregates").
		Body(featureGate).
		Do().
		Into(result)
	return
}

// Update takes the representation of a featureGate and updates it. Returns the server's representation of the featureGate, and an error, if there is any.
func (c *featureGates) Update(featureGate *v1.FeatureGate) (result *v1.FeatureGate, err error) {
	result = &v1.FeatureGate{}
	err = c.client.Put().
		Resource("featuregates").
		Name(featureGate.Name).
		Body(featureGate).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *featureGates) UpdateStatus(featureGate *v1.FeatureGate) (result *v1.FeatureGate, err error) {
	result = &v1.FeatureGate{}
	err = c.client.Put().
		Resource("featuregates").
		Name(featureGate.Name).
		SubResource("status").
		Body(featureGate).
		Do().
		Into(result)
	return
}

// Delete takes name of the featureGate and deletes it. Returns an error if one occurs.
func (c *featureGates) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("featuregates").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *featureGates) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("featuregates").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched featureGate.
func (c *featureGates) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.FeatureGate, err error) {
	result = &v1.FeatureGate{}
	err = c.client.Patch(pt).
		Resource("featuregates").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
