// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/area120/tables/v1alpha1/tables.proto

package tables

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Column identifier used for the values in the row.
type View int32

const (
	// Defaults to user entered text.
	View_VIEW_UNSPECIFIED View = 0
	// Uses internally generated column id to identify values.
	View_COLUMN_ID_VIEW View = 1
)

// Enum value maps for View.
var (
	View_name = map[int32]string{
		0: "VIEW_UNSPECIFIED",
		1: "COLUMN_ID_VIEW",
	}
	View_value = map[string]int32{
		"VIEW_UNSPECIFIED": 0,
		"COLUMN_ID_VIEW":   1,
	}
)

func (x View) Enum() *View {
	p := new(View)
	*p = x
	return p
}

func (x View) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (View) Descriptor() protoreflect.EnumDescriptor {
	return file_google_area120_tables_v1alpha1_tables_proto_enumTypes[0].Descriptor()
}

func (View) Type() protoreflect.EnumType {
	return &file_google_area120_tables_v1alpha1_tables_proto_enumTypes[0]
}

func (x View) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use View.Descriptor instead.
func (View) EnumDescriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{0}
}

// Request message for TablesService.GetTable.
type GetTableRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the table to retrieve.
	// Format: tables/{table}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTableRequest) Reset() {
	*x = GetTableRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTableRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTableRequest) ProtoMessage() {}

func (x *GetTableRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTableRequest.ProtoReflect.Descriptor instead.
func (*GetTableRequest) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{0}
}

func (x *GetTableRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for TablesService.ListTables.
type ListTablesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of tables to return. The service may return fewer than
	// this value.
	//
	// If unspecified, at most 20 tables are returned. The maximum value is 100;
	// values above 100 are coerced to 100.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListTables` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListTables` must match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTablesRequest) Reset() {
	*x = ListTablesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTablesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTablesRequest) ProtoMessage() {}

func (x *ListTablesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTablesRequest.ProtoReflect.Descriptor instead.
func (*ListTablesRequest) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{1}
}

func (x *ListTablesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTablesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for TablesService.ListTables.
type ListTablesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of tables.
	Tables []*Table `protobuf:"bytes,1,rep,name=tables,proto3" json:"tables,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is empty, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTablesResponse) Reset() {
	*x = ListTablesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTablesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTablesResponse) ProtoMessage() {}

func (x *ListTablesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTablesResponse.ProtoReflect.Descriptor instead.
func (*ListTablesResponse) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{2}
}

func (x *ListTablesResponse) GetTables() []*Table {
	if x != nil {
		return x.Tables
	}
	return nil
}

func (x *ListTablesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for TablesService.GetRow.
type GetRowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the row to retrieve.
	// Format: tables/{table}/rows/{row}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Column key to use for values in the row.
	// Defaults to user entered name.
	View View `protobuf:"varint,2,opt,name=view,proto3,enum=google.area120.tables.v1alpha1.View" json:"view,omitempty"`
}

func (x *GetRowRequest) Reset() {
	*x = GetRowRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRowRequest) ProtoMessage() {}

func (x *GetRowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRowRequest.ProtoReflect.Descriptor instead.
func (*GetRowRequest) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{3}
}

func (x *GetRowRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetRowRequest) GetView() View {
	if x != nil {
		return x.View
	}
	return View_VIEW_UNSPECIFIED
}

// Request message for TablesService.ListRows.
type ListRowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent table.
	// Format: tables/{table}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of rows to return. The service may return fewer than
	// this value.
	//
	// If unspecified, at most 50 rows are returned. The maximum value is 1,000;
	// values above 1,000 are coerced to 1,000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListRows` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListRows` must match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Column key to use for values in the row.
	// Defaults to user entered name.
	View View `protobuf:"varint,4,opt,name=view,proto3,enum=google.area120.tables.v1alpha1.View" json:"view,omitempty"`
}

func (x *ListRowsRequest) Reset() {
	*x = ListRowsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRowsRequest) ProtoMessage() {}

func (x *ListRowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRowsRequest.ProtoReflect.Descriptor instead.
func (*ListRowsRequest) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{4}
}

func (x *ListRowsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRowsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRowsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRowsRequest) GetView() View {
	if x != nil {
		return x.View
	}
	return View_VIEW_UNSPECIFIED
}

// Response message for TablesService.ListRows.
type ListRowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rows from the specified table.
	Rows []*Row `protobuf:"bytes,1,rep,name=rows,proto3" json:"rows,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is empty, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRowsResponse) Reset() {
	*x = ListRowsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRowsResponse) ProtoMessage() {}

func (x *ListRowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRowsResponse.ProtoReflect.Descriptor instead.
func (*ListRowsResponse) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{5}
}

func (x *ListRowsResponse) GetRows() []*Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *ListRowsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for TablesService.CreateRow.
type CreateRowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent table where this row will be created.
	// Format: tables/{table}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The row to create.
	Row *Row `protobuf:"bytes,2,opt,name=row,proto3" json:"row,omitempty"`
	// Optional. Column key to use for values in the row.
	// Defaults to user entered name.
	View View `protobuf:"varint,3,opt,name=view,proto3,enum=google.area120.tables.v1alpha1.View" json:"view,omitempty"`
}

func (x *CreateRowRequest) Reset() {
	*x = CreateRowRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRowRequest) ProtoMessage() {}

func (x *CreateRowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRowRequest.ProtoReflect.Descriptor instead.
func (*CreateRowRequest) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{6}
}

func (x *CreateRowRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRowRequest) GetRow() *Row {
	if x != nil {
		return x.Row
	}
	return nil
}

func (x *CreateRowRequest) GetView() View {
	if x != nil {
		return x.View
	}
	return View_VIEW_UNSPECIFIED
}

// Request message for TablesService.BatchCreateRows.
type BatchCreateRowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent table where the rows will be created.
	// Format: tables/{table}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request message specifying the rows to create.
	//
	// A maximum of 500 rows can be created in a single batch.
	Requests []*CreateRowRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateRowsRequest) Reset() {
	*x = BatchCreateRowsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateRowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateRowsRequest) ProtoMessage() {}

func (x *BatchCreateRowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateRowsRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateRowsRequest) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{7}
}

func (x *BatchCreateRowsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateRowsRequest) GetRequests() []*CreateRowRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for TablesService.BatchCreateRows.
type BatchCreateRowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created rows.
	Rows []*Row `protobuf:"bytes,1,rep,name=rows,proto3" json:"rows,omitempty"`
}

func (x *BatchCreateRowsResponse) Reset() {
	*x = BatchCreateRowsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateRowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateRowsResponse) ProtoMessage() {}

func (x *BatchCreateRowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateRowsResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateRowsResponse) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{8}
}

func (x *BatchCreateRowsResponse) GetRows() []*Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

// Request message for TablesService.UpdateRow.
type UpdateRowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The row to update.
	Row *Row `protobuf:"bytes,1,opt,name=row,proto3" json:"row,omitempty"`
	// The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. Column key to use for values in the row.
	// Defaults to user entered name.
	View View `protobuf:"varint,3,opt,name=view,proto3,enum=google.area120.tables.v1alpha1.View" json:"view,omitempty"`
}

func (x *UpdateRowRequest) Reset() {
	*x = UpdateRowRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRowRequest) ProtoMessage() {}

func (x *UpdateRowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRowRequest.ProtoReflect.Descriptor instead.
func (*UpdateRowRequest) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateRowRequest) GetRow() *Row {
	if x != nil {
		return x.Row
	}
	return nil
}

func (x *UpdateRowRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateRowRequest) GetView() View {
	if x != nil {
		return x.View
	}
	return View_VIEW_UNSPECIFIED
}

// Request message for TablesService.BatchUpdateRows.
type BatchUpdateRowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent table shared by all rows being updated.
	// Format: tables/{table}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request messages specifying the rows to update.
	//
	// A maximum of 500 rows can be modified in a single batch.
	Requests []*UpdateRowRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchUpdateRowsRequest) Reset() {
	*x = BatchUpdateRowsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateRowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateRowsRequest) ProtoMessage() {}

func (x *BatchUpdateRowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateRowsRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdateRowsRequest) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{10}
}

func (x *BatchUpdateRowsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchUpdateRowsRequest) GetRequests() []*UpdateRowRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for TablesService.BatchUpdateRows.
type BatchUpdateRowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The updated rows.
	Rows []*Row `protobuf:"bytes,1,rep,name=rows,proto3" json:"rows,omitempty"`
}

func (x *BatchUpdateRowsResponse) Reset() {
	*x = BatchUpdateRowsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateRowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateRowsResponse) ProtoMessage() {}

func (x *BatchUpdateRowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateRowsResponse.ProtoReflect.Descriptor instead.
func (*BatchUpdateRowsResponse) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{11}
}

func (x *BatchUpdateRowsResponse) GetRows() []*Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

// Request message for TablesService.DeleteRow
type DeleteRowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the row to delete.
	// Format: tables/{table}/rows/{row}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteRowRequest) Reset() {
	*x = DeleteRowRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRowRequest) ProtoMessage() {}

func (x *DeleteRowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRowRequest.ProtoReflect.Descriptor instead.
func (*DeleteRowRequest) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteRowRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A single table.
type Table struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the table.
	// Table names have the form `tables/{table}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The human readable title of the table.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// List of columns in this table.
	// Order of columns matches the display order.
	Columns []*ColumnDescription `protobuf:"bytes,3,rep,name=columns,proto3" json:"columns,omitempty"`
}

func (x *Table) Reset() {
	*x = Table{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Table) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Table) ProtoMessage() {}

func (x *Table) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Table.ProtoReflect.Descriptor instead.
func (*Table) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{13}
}

func (x *Table) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Table) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Table) GetColumns() []*ColumnDescription {
	if x != nil {
		return x.Columns
	}
	return nil
}

// Details on a column in the table.
type ColumnDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// column name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Data type of the column
	// Supported types are number, text, boolean, number_list, text_list,
	// boolean_list.
	DataType string `protobuf:"bytes,2,opt,name=data_type,json=dataType,proto3" json:"data_type,omitempty"`
	// Internal id for a column.
	Id string `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *ColumnDescription) Reset() {
	*x = ColumnDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColumnDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnDescription) ProtoMessage() {}

func (x *ColumnDescription) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColumnDescription.ProtoReflect.Descriptor instead.
func (*ColumnDescription) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{14}
}

func (x *ColumnDescription) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ColumnDescription) GetDataType() string {
	if x != nil {
		return x.DataType
	}
	return ""
}

func (x *ColumnDescription) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// A single row in a table.
type Row struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the row.
	// Row names have the form `tables/{table}/rows/{row}`.
	// The name is ignored when creating a row.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The values of the row. This is a map of column key to value.
	// Key is user entered name(default) or the internal column id based on
	// the view in the request.
	Values map[string]*structpb.Value `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Row) Reset() {
	*x = Row{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Row) ProtoMessage() {}

func (x *Row) ProtoReflect() protoreflect.Message {
	mi := &file_google_area120_tables_v1alpha1_tables_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Row.ProtoReflect.Descriptor instead.
func (*Row) Descriptor() ([]byte, []int) {
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP(), []int{15}
}

func (x *Row) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Row) GetValues() map[string]*structpb.Value {
	if x != nil {
		return x.Values
	}
	return nil
}

var File_google_area120_tables_v1alpha1_tables_proto protoreflect.FileDescriptor

var file_google_area120_tables_v1alpha1_tables_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30,
	0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x2a, 0x0a,
	0x0f, 0x47, 0x65, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x4f, 0x0a, 0x11, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7b, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3d, 0x0a, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32,
	0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x67, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x52, 0x6f,
	0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x3d, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30,
	0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77,
	0x22, 0xa9, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x3d, 0x0a,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x65,
	0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x73, 0x0a, 0x10,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x37, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xaa, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x03, 0x72, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32,
	0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x52, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x72, 0x6f, 0x77, 0x12,
	0x3d, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56,
	0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x88,
	0x01, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f,
	0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x51, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x52, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x52, 0x0a, 0x17, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61,
	0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x22, 0xca, 0x01,
	0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3a, 0x0a, 0x03, 0x72, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30,
	0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x52, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x72, 0x6f, 0x77, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x3d, 0x0a, 0x04, 0x76,
	0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x88, 0x01, 0x0a, 0x16, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x51, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72,
	0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x52, 0x0a, 0x17, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x37, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x22, 0x50, 0x0a, 0x10, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x22, 0x0a, 0x20, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc4, 0x01, 0x0a, 0x05,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x07,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x3a, 0x37, 0xea, 0x41, 0x34, 0x0a, 0x22,
	0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x0e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x7d, 0x22, 0x54, 0x0a, 0x11, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0xf7, 0x01, 0x0a, 0x03, 0x52, 0x6f, 0x77,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72,
	0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x6f, 0x77, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x51, 0x0a,
	0x0b, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x3a, 0x40, 0xea, 0x41, 0x3d, 0x0a, 0x20, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x77, 0x12, 0x19, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f,
	0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x7d, 0x2f, 0x72, 0x6f, 0x77, 0x73, 0x2f, 0x7b, 0x72, 0x6f,
	0x77, 0x7d, 0x2a, 0x30, 0x0a, 0x04, 0x56, 0x69, 0x65, 0x77, 0x12, 0x14, 0x0a, 0x10, 0x56, 0x49,
	0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x12, 0x0a, 0x0e, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x5f, 0x49, 0x44, 0x5f, 0x56, 0x49,
	0x45, 0x57, 0x10, 0x01, 0x32, 0xb9, 0x0d, 0x0a, 0x0d, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8c, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65,
	0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72,
	0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x28, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x1b, 0x12, 0x19, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x8d, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72,
	0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x18, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x12, 0x12, 0x10, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x8d, 0x01, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x77,
	0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32,
	0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30,
	0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x52, 0x6f, 0x77, 0x22, 0x2f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22, 0x12, 0x20, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xa0, 0x01, 0x0a, 0x08, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f,
	0x77, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61,
	0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65,
	0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x31, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22, 0x12, 0x20, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x77, 0x73, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x9e, 0x01, 0x0a, 0x09, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f,
	0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x6f, 0x77, 0x22, 0x3a, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x27, 0x22, 0x20, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x77, 0x73, 0x3a, 0x03, 0x72, 0x6f, 0x77, 0xda, 0x41, 0x0a, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x6f, 0x77, 0x12, 0xbb, 0x01, 0x0a, 0x0f, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x37,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x77, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xa7, 0x01, 0x0a, 0x09, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x52, 0x6f, 0x77, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x6f, 0x77, 0x22, 0x43, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2b, 0x32, 0x24, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f,
	0x7b, 0x72, 0x6f, 0x77, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x03, 0x72, 0x6f, 0x77, 0xda,
	0x41, 0x0f, 0x72, 0x6f, 0x77, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x12, 0xbb, 0x01, 0x0a, 0x0f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x22, 0x2c,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x77, 0x73,
	0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12,
	0x86, 0x01, 0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x12, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x2f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22, 0x2a,
	0x20, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x77, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x85, 0x02, 0xca, 0x41, 0x1c, 0x61, 0x72,
	0x65, 0x61, 0x31, 0x32, 0x30, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0xe2, 0x01, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x2c, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x73, 0x70,
	0x72, 0x65, 0x61, 0x64, 0x73, 0x68, 0x65, 0x65, 0x74, 0x73, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x73, 0x70, 0x72, 0x65, 0x61,
	0x64, 0x73, 0x68, 0x65, 0x65, 0x74, 0x73, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79,
	0x42, 0x79, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x72, 0x65, 0x61, 0x31, 0x32, 0x30, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x42, 0x0b, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x72, 0x65,
	0x61, 0x31, 0x32, 0x30, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x3b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_area120_tables_v1alpha1_tables_proto_rawDescOnce sync.Once
	file_google_area120_tables_v1alpha1_tables_proto_rawDescData = file_google_area120_tables_v1alpha1_tables_proto_rawDesc
)

func file_google_area120_tables_v1alpha1_tables_proto_rawDescGZIP() []byte {
	file_google_area120_tables_v1alpha1_tables_proto_rawDescOnce.Do(func() {
		file_google_area120_tables_v1alpha1_tables_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_area120_tables_v1alpha1_tables_proto_rawDescData)
	})
	return file_google_area120_tables_v1alpha1_tables_proto_rawDescData
}

var file_google_area120_tables_v1alpha1_tables_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_area120_tables_v1alpha1_tables_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_area120_tables_v1alpha1_tables_proto_goTypes = []interface{}{
	(View)(0),                       // 0: google.area120.tables.v1alpha1.View
	(*GetTableRequest)(nil),         // 1: google.area120.tables.v1alpha1.GetTableRequest
	(*ListTablesRequest)(nil),       // 2: google.area120.tables.v1alpha1.ListTablesRequest
	(*ListTablesResponse)(nil),      // 3: google.area120.tables.v1alpha1.ListTablesResponse
	(*GetRowRequest)(nil),           // 4: google.area120.tables.v1alpha1.GetRowRequest
	(*ListRowsRequest)(nil),         // 5: google.area120.tables.v1alpha1.ListRowsRequest
	(*ListRowsResponse)(nil),        // 6: google.area120.tables.v1alpha1.ListRowsResponse
	(*CreateRowRequest)(nil),        // 7: google.area120.tables.v1alpha1.CreateRowRequest
	(*BatchCreateRowsRequest)(nil),  // 8: google.area120.tables.v1alpha1.BatchCreateRowsRequest
	(*BatchCreateRowsResponse)(nil), // 9: google.area120.tables.v1alpha1.BatchCreateRowsResponse
	(*UpdateRowRequest)(nil),        // 10: google.area120.tables.v1alpha1.UpdateRowRequest
	(*BatchUpdateRowsRequest)(nil),  // 11: google.area120.tables.v1alpha1.BatchUpdateRowsRequest
	(*BatchUpdateRowsResponse)(nil), // 12: google.area120.tables.v1alpha1.BatchUpdateRowsResponse
	(*DeleteRowRequest)(nil),        // 13: google.area120.tables.v1alpha1.DeleteRowRequest
	(*Table)(nil),                   // 14: google.area120.tables.v1alpha1.Table
	(*ColumnDescription)(nil),       // 15: google.area120.tables.v1alpha1.ColumnDescription
	(*Row)(nil),                     // 16: google.area120.tables.v1alpha1.Row
	nil,                             // 17: google.area120.tables.v1alpha1.Row.ValuesEntry
	(*fieldmaskpb.FieldMask)(nil),   // 18: google.protobuf.FieldMask
	(*structpb.Value)(nil),          // 19: google.protobuf.Value
	(*emptypb.Empty)(nil),           // 20: google.protobuf.Empty
}
var file_google_area120_tables_v1alpha1_tables_proto_depIdxs = []int32{
	14, // 0: google.area120.tables.v1alpha1.ListTablesResponse.tables:type_name -> google.area120.tables.v1alpha1.Table
	0,  // 1: google.area120.tables.v1alpha1.GetRowRequest.view:type_name -> google.area120.tables.v1alpha1.View
	0,  // 2: google.area120.tables.v1alpha1.ListRowsRequest.view:type_name -> google.area120.tables.v1alpha1.View
	16, // 3: google.area120.tables.v1alpha1.ListRowsResponse.rows:type_name -> google.area120.tables.v1alpha1.Row
	16, // 4: google.area120.tables.v1alpha1.CreateRowRequest.row:type_name -> google.area120.tables.v1alpha1.Row
	0,  // 5: google.area120.tables.v1alpha1.CreateRowRequest.view:type_name -> google.area120.tables.v1alpha1.View
	7,  // 6: google.area120.tables.v1alpha1.BatchCreateRowsRequest.requests:type_name -> google.area120.tables.v1alpha1.CreateRowRequest
	16, // 7: google.area120.tables.v1alpha1.BatchCreateRowsResponse.rows:type_name -> google.area120.tables.v1alpha1.Row
	16, // 8: google.area120.tables.v1alpha1.UpdateRowRequest.row:type_name -> google.area120.tables.v1alpha1.Row
	18, // 9: google.area120.tables.v1alpha1.UpdateRowRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 10: google.area120.tables.v1alpha1.UpdateRowRequest.view:type_name -> google.area120.tables.v1alpha1.View
	10, // 11: google.area120.tables.v1alpha1.BatchUpdateRowsRequest.requests:type_name -> google.area120.tables.v1alpha1.UpdateRowRequest
	16, // 12: google.area120.tables.v1alpha1.BatchUpdateRowsResponse.rows:type_name -> google.area120.tables.v1alpha1.Row
	15, // 13: google.area120.tables.v1alpha1.Table.columns:type_name -> google.area120.tables.v1alpha1.ColumnDescription
	17, // 14: google.area120.tables.v1alpha1.Row.values:type_name -> google.area120.tables.v1alpha1.Row.ValuesEntry
	19, // 15: google.area120.tables.v1alpha1.Row.ValuesEntry.value:type_name -> google.protobuf.Value
	1,  // 16: google.area120.tables.v1alpha1.TablesService.GetTable:input_type -> google.area120.tables.v1alpha1.GetTableRequest
	2,  // 17: google.area120.tables.v1alpha1.TablesService.ListTables:input_type -> google.area120.tables.v1alpha1.ListTablesRequest
	4,  // 18: google.area120.tables.v1alpha1.TablesService.GetRow:input_type -> google.area120.tables.v1alpha1.GetRowRequest
	5,  // 19: google.area120.tables.v1alpha1.TablesService.ListRows:input_type -> google.area120.tables.v1alpha1.ListRowsRequest
	7,  // 20: google.area120.tables.v1alpha1.TablesService.CreateRow:input_type -> google.area120.tables.v1alpha1.CreateRowRequest
	8,  // 21: google.area120.tables.v1alpha1.TablesService.BatchCreateRows:input_type -> google.area120.tables.v1alpha1.BatchCreateRowsRequest
	10, // 22: google.area120.tables.v1alpha1.TablesService.UpdateRow:input_type -> google.area120.tables.v1alpha1.UpdateRowRequest
	11, // 23: google.area120.tables.v1alpha1.TablesService.BatchUpdateRows:input_type -> google.area120.tables.v1alpha1.BatchUpdateRowsRequest
	13, // 24: google.area120.tables.v1alpha1.TablesService.DeleteRow:input_type -> google.area120.tables.v1alpha1.DeleteRowRequest
	14, // 25: google.area120.tables.v1alpha1.TablesService.GetTable:output_type -> google.area120.tables.v1alpha1.Table
	3,  // 26: google.area120.tables.v1alpha1.TablesService.ListTables:output_type -> google.area120.tables.v1alpha1.ListTablesResponse
	16, // 27: google.area120.tables.v1alpha1.TablesService.GetRow:output_type -> google.area120.tables.v1alpha1.Row
	6,  // 28: google.area120.tables.v1alpha1.TablesService.ListRows:output_type -> google.area120.tables.v1alpha1.ListRowsResponse
	16, // 29: google.area120.tables.v1alpha1.TablesService.CreateRow:output_type -> google.area120.tables.v1alpha1.Row
	9,  // 30: google.area120.tables.v1alpha1.TablesService.BatchCreateRows:output_type -> google.area120.tables.v1alpha1.BatchCreateRowsResponse
	16, // 31: google.area120.tables.v1alpha1.TablesService.UpdateRow:output_type -> google.area120.tables.v1alpha1.Row
	12, // 32: google.area120.tables.v1alpha1.TablesService.BatchUpdateRows:output_type -> google.area120.tables.v1alpha1.BatchUpdateRowsResponse
	20, // 33: google.area120.tables.v1alpha1.TablesService.DeleteRow:output_type -> google.protobuf.Empty
	25, // [25:34] is the sub-list for method output_type
	16, // [16:25] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_area120_tables_v1alpha1_tables_proto_init() }
func file_google_area120_tables_v1alpha1_tables_proto_init() {
	if File_google_area120_tables_v1alpha1_tables_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTableRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTablesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTablesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRowRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRowsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRowsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRowRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateRowsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateRowsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRowRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateRowsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateRowsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRowRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Table); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ColumnDescription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_area120_tables_v1alpha1_tables_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Row); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_area120_tables_v1alpha1_tables_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_area120_tables_v1alpha1_tables_proto_goTypes,
		DependencyIndexes: file_google_area120_tables_v1alpha1_tables_proto_depIdxs,
		EnumInfos:         file_google_area120_tables_v1alpha1_tables_proto_enumTypes,
		MessageInfos:      file_google_area120_tables_v1alpha1_tables_proto_msgTypes,
	}.Build()
	File_google_area120_tables_v1alpha1_tables_proto = out.File
	file_google_area120_tables_v1alpha1_tables_proto_rawDesc = nil
	file_google_area120_tables_v1alpha1_tables_proto_goTypes = nil
	file_google_area120_tables_v1alpha1_tables_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TablesServiceClient is the client API for TablesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TablesServiceClient interface {
	// Gets a table. Returns NOT_FOUND if the table does not exist.
	GetTable(ctx context.Context, in *GetTableRequest, opts ...grpc.CallOption) (*Table, error)
	// Lists tables for the user.
	ListTables(ctx context.Context, in *ListTablesRequest, opts ...grpc.CallOption) (*ListTablesResponse, error)
	// Gets a row. Returns NOT_FOUND if the row does not exist in the table.
	GetRow(ctx context.Context, in *GetRowRequest, opts ...grpc.CallOption) (*Row, error)
	// Lists rows in a table. Returns NOT_FOUND if the table does not exist.
	ListRows(ctx context.Context, in *ListRowsRequest, opts ...grpc.CallOption) (*ListRowsResponse, error)
	// Creates a row.
	CreateRow(ctx context.Context, in *CreateRowRequest, opts ...grpc.CallOption) (*Row, error)
	// Creates multiple rows.
	BatchCreateRows(ctx context.Context, in *BatchCreateRowsRequest, opts ...grpc.CallOption) (*BatchCreateRowsResponse, error)
	// Updates a row.
	UpdateRow(ctx context.Context, in *UpdateRowRequest, opts ...grpc.CallOption) (*Row, error)
	// Updates multiple rows.
	BatchUpdateRows(ctx context.Context, in *BatchUpdateRowsRequest, opts ...grpc.CallOption) (*BatchUpdateRowsResponse, error)
	// Deletes a row.
	DeleteRow(ctx context.Context, in *DeleteRowRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type tablesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTablesServiceClient(cc grpc.ClientConnInterface) TablesServiceClient {
	return &tablesServiceClient{cc}
}

func (c *tablesServiceClient) GetTable(ctx context.Context, in *GetTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, "/google.area120.tables.v1alpha1.TablesService/GetTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) ListTables(ctx context.Context, in *ListTablesRequest, opts ...grpc.CallOption) (*ListTablesResponse, error) {
	out := new(ListTablesResponse)
	err := c.cc.Invoke(ctx, "/google.area120.tables.v1alpha1.TablesService/ListTables", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) GetRow(ctx context.Context, in *GetRowRequest, opts ...grpc.CallOption) (*Row, error) {
	out := new(Row)
	err := c.cc.Invoke(ctx, "/google.area120.tables.v1alpha1.TablesService/GetRow", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) ListRows(ctx context.Context, in *ListRowsRequest, opts ...grpc.CallOption) (*ListRowsResponse, error) {
	out := new(ListRowsResponse)
	err := c.cc.Invoke(ctx, "/google.area120.tables.v1alpha1.TablesService/ListRows", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) CreateRow(ctx context.Context, in *CreateRowRequest, opts ...grpc.CallOption) (*Row, error) {
	out := new(Row)
	err := c.cc.Invoke(ctx, "/google.area120.tables.v1alpha1.TablesService/CreateRow", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) BatchCreateRows(ctx context.Context, in *BatchCreateRowsRequest, opts ...grpc.CallOption) (*BatchCreateRowsResponse, error) {
	out := new(BatchCreateRowsResponse)
	err := c.cc.Invoke(ctx, "/google.area120.tables.v1alpha1.TablesService/BatchCreateRows", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) UpdateRow(ctx context.Context, in *UpdateRowRequest, opts ...grpc.CallOption) (*Row, error) {
	out := new(Row)
	err := c.cc.Invoke(ctx, "/google.area120.tables.v1alpha1.TablesService/UpdateRow", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) BatchUpdateRows(ctx context.Context, in *BatchUpdateRowsRequest, opts ...grpc.CallOption) (*BatchUpdateRowsResponse, error) {
	out := new(BatchUpdateRowsResponse)
	err := c.cc.Invoke(ctx, "/google.area120.tables.v1alpha1.TablesService/BatchUpdateRows", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tablesServiceClient) DeleteRow(ctx context.Context, in *DeleteRowRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.area120.tables.v1alpha1.TablesService/DeleteRow", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TablesServiceServer is the server API for TablesService service.
type TablesServiceServer interface {
	// Gets a table. Returns NOT_FOUND if the table does not exist.
	GetTable(context.Context, *GetTableRequest) (*Table, error)
	// Lists tables for the user.
	ListTables(context.Context, *ListTablesRequest) (*ListTablesResponse, error)
	// Gets a row. Returns NOT_FOUND if the row does not exist in the table.
	GetRow(context.Context, *GetRowRequest) (*Row, error)
	// Lists rows in a table. Returns NOT_FOUND if the table does not exist.
	ListRows(context.Context, *ListRowsRequest) (*ListRowsResponse, error)
	// Creates a row.
	CreateRow(context.Context, *CreateRowRequest) (*Row, error)
	// Creates multiple rows.
	BatchCreateRows(context.Context, *BatchCreateRowsRequest) (*BatchCreateRowsResponse, error)
	// Updates a row.
	UpdateRow(context.Context, *UpdateRowRequest) (*Row, error)
	// Updates multiple rows.
	BatchUpdateRows(context.Context, *BatchUpdateRowsRequest) (*BatchUpdateRowsResponse, error)
	// Deletes a row.
	DeleteRow(context.Context, *DeleteRowRequest) (*emptypb.Empty, error)
}

// UnimplementedTablesServiceServer can be embedded to have forward compatible implementations.
type UnimplementedTablesServiceServer struct {
}

func (*UnimplementedTablesServiceServer) GetTable(context.Context, *GetTableRequest) (*Table, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTable not implemented")
}
func (*UnimplementedTablesServiceServer) ListTables(context.Context, *ListTablesRequest) (*ListTablesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTables not implemented")
}
func (*UnimplementedTablesServiceServer) GetRow(context.Context, *GetRowRequest) (*Row, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRow not implemented")
}
func (*UnimplementedTablesServiceServer) ListRows(context.Context, *ListRowsRequest) (*ListRowsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRows not implemented")
}
func (*UnimplementedTablesServiceServer) CreateRow(context.Context, *CreateRowRequest) (*Row, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRow not implemented")
}
func (*UnimplementedTablesServiceServer) BatchCreateRows(context.Context, *BatchCreateRowsRequest) (*BatchCreateRowsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateRows not implemented")
}
func (*UnimplementedTablesServiceServer) UpdateRow(context.Context, *UpdateRowRequest) (*Row, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRow not implemented")
}
func (*UnimplementedTablesServiceServer) BatchUpdateRows(context.Context, *BatchUpdateRowsRequest) (*BatchUpdateRowsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateRows not implemented")
}
func (*UnimplementedTablesServiceServer) DeleteRow(context.Context, *DeleteRowRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRow not implemented")
}

func RegisterTablesServiceServer(s *grpc.Server, srv TablesServiceServer) {
	s.RegisterService(&_TablesService_serviceDesc, srv)
}

func _TablesService_GetTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).GetTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.area120.tables.v1alpha1.TablesService/GetTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).GetTable(ctx, req.(*GetTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_ListTables_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTablesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).ListTables(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.area120.tables.v1alpha1.TablesService/ListTables",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).ListTables(ctx, req.(*ListTablesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_GetRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).GetRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.area120.tables.v1alpha1.TablesService/GetRow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).GetRow(ctx, req.(*GetRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_ListRows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).ListRows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.area120.tables.v1alpha1.TablesService/ListRows",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).ListRows(ctx, req.(*ListRowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_CreateRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).CreateRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.area120.tables.v1alpha1.TablesService/CreateRow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).CreateRow(ctx, req.(*CreateRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_BatchCreateRows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateRowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).BatchCreateRows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.area120.tables.v1alpha1.TablesService/BatchCreateRows",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).BatchCreateRows(ctx, req.(*BatchCreateRowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_UpdateRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).UpdateRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.area120.tables.v1alpha1.TablesService/UpdateRow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).UpdateRow(ctx, req.(*UpdateRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_BatchUpdateRows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateRowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).BatchUpdateRows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.area120.tables.v1alpha1.TablesService/BatchUpdateRows",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).BatchUpdateRows(ctx, req.(*BatchUpdateRowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TablesService_DeleteRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TablesServiceServer).DeleteRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.area120.tables.v1alpha1.TablesService/DeleteRow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TablesServiceServer).DeleteRow(ctx, req.(*DeleteRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TablesService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.area120.tables.v1alpha1.TablesService",
	HandlerType: (*TablesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetTable",
			Handler:    _TablesService_GetTable_Handler,
		},
		{
			MethodName: "ListTables",
			Handler:    _TablesService_ListTables_Handler,
		},
		{
			MethodName: "GetRow",
			Handler:    _TablesService_GetRow_Handler,
		},
		{
			MethodName: "ListRows",
			Handler:    _TablesService_ListRows_Handler,
		},
		{
			MethodName: "CreateRow",
			Handler:    _TablesService_CreateRow_Handler,
		},
		{
			MethodName: "BatchCreateRows",
			Handler:    _TablesService_BatchCreateRows_Handler,
		},
		{
			MethodName: "UpdateRow",
			Handler:    _TablesService_UpdateRow_Handler,
		},
		{
			MethodName: "BatchUpdateRows",
			Handler:    _TablesService_BatchUpdateRows_Handler,
		},
		{
			MethodName: "DeleteRow",
			Handler:    _TablesService_DeleteRow_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/area120/tables/v1alpha1/tables.proto",
}
