"use strict";

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@storybook/react");

var _addonKnobs = require("@storybook/addon-knobs");

var _addonActions = require("@storybook/addon-actions");

var _ProgressIndicator = require("../ProgressIndicator");

var _ProgressIndicator2 = _interopRequireDefault(require("../ProgressIndicator/ProgressIndicator.Skeleton"));

var _Tooltip = _interopRequireDefault(require("../Tooltip"));

var _carbonComponents = require("carbon-components");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix;
(0, _react2.storiesOf)('ProgressIndicator', module).addDecorator(_addonKnobs.withKnobs).add('Default', function () {
  return _react.default.createElement(_ProgressIndicator.ProgressIndicator, {
    currentIndex: (0, _addonKnobs.number)('Current progress (currentIndex)', 1)
  }, _react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "First step",
    description: "Step 1: Getting started with Carbon Design System",
    secondaryLabel: "Optional label"
  }), _react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "Second step with tooltip",
    description: "Step 2: Getting started with Carbon Design System",
    renderLabel: function renderLabel() {
      return _react.default.createElement(_Tooltip.default, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "".concat(prefix, "--progress-label"),
        triggerText: 'Second step with tooltip',
        tooltipId: "tooltipId-0"
      }, _react.default.createElement("p", null, "Overflow tooltip content."));
    }
  }), _react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "Third step with tooltip",
    description: "Step 3: Getting started with Carbon Design System",
    renderLabel: function renderLabel() {
      return _react.default.createElement(_Tooltip.default, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "".concat(prefix, "--progress-label"),
        triggerText: 'Third step with tooltip',
        tooltipId: "tooltipId-1"
      }, _react.default.createElement("p", null, "Lorem ipsum dolor, sit amet consectetur adipisicing elit. Animi consequuntur hic ratione aliquid cupiditate, nesciunt saepe iste blanditiis cumque maxime tenetur veniam est illo deserunt sint quae pariatur. Laboriosam, consequatur."));
    }
  }), _react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "Fourth step",
    description: "Step 4: Getting started with Carbon Design System",
    invalid: true,
    secondaryLabel: "Example invalid step"
  }), _react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "Fifth step",
    description: "Step 5: Getting started with Carbon Design System",
    disabled: true
  }));
}, {
  info: {
    text: "\n            For React usage, ProgressIndicator holds the currentIndex state to indicate which ProgressStep is the current step. The ProgressIndicator component should always be used with ProgressStep components as its children. Changing currentIndex prop will automatically set the ProgressStep components props (complete, incomplete, current).\n            For general usage, Progress Indicators display steps in a process. It should indicate when steps have been complete, the active step,\n            and the steps to come.\n          "
  }
}).add('interactive', function () {
  return _react.default.createElement(_ProgressIndicator.ProgressIndicator, {
    currentIndex: (0, _addonKnobs.number)('Current progress (currentIndex)', 1),
    onChange: (0, _addonActions.action)('onChange')
  }, _react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "Click me",
    description: "Step 1: Register a onChange event"
  }), _react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "Really long label",
    description: "The progress indicator will listen for clicks on the steps"
  }), _react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "Tooltip and really long label",
    description: "The progress indicator will listen for clicks on the steps",
    renderLabel: function renderLabel() {
      return _react.default.createElement(_Tooltip.default, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "".concat(prefix, "--progress-label"),
        triggerText: "Tooltip and really long label",
        tooltipId: "tooltipId-1"
      }, _react.default.createElement("p", null, "Lorem ipsum dolor, sit amet consectetur adipisicing elit. Animi consequuntur hic ratione aliquid cupiditate, nesciunt saepe iste blanditiis cumque maxime tenetur veniam est illo deserunt sint quae pariatur. Laboriosam, consequatur."));
    }
  }));
}, {
  info: {
    text: "\n           If you register an onChange handler, the Progress Indicator will become interactive.  Your parent component should update the currentIndex prop within the onChange handler.\n          "
  }
}).add('skeleton', function () {
  return _react.default.createElement(_ProgressIndicator2.default, null);
}, {
  info: {
    text: "\n            Placeholder skeleton state to use when content is loading.\n        "
  }
});