"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPieOrigin = void 0;
const victory_core_1 = require("victory-core");
// Returns the origin for pie based charts. For example, something with a radius such as pie, donut, donut utilization,
// and donut threshold.
const getPieOrigin = ({ height, padding, width }) => {
    const { top, bottom, left, right } = victory_core_1.Helpers.getPadding({ padding });
    const radius = victory_core_1.Helpers.getRadius({ height, width, padding });
    const offsetX = (width - radius * 2 - left - right) / 2;
    const offsetY = (height - radius * 2 - top - bottom) / 2;
    return {
        x: radius + left + offsetX,
        y: radius + top + offsetY
    };
};
exports.getPieOrigin = getPieOrigin;
//# sourceMappingURL=chart-origin.js.map