"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getInteractiveLegendItemStyles = exports.getInteractiveLegendEvents = void 0;
const tslib_1 = require("tslib");
/* eslint-disable camelcase */
const chart_area_Opacity_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_area_Opacity'));
const chart_color_black_500_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_color_black_500'));
// Returns child names for each series, except given ID index
const getChildNames = ({ chartNames, omitIndex }) => {
    const result = [];
    chartNames.map((chartName, index) => {
        if (index !== omitIndex) {
            if (Array.isArray(chartName)) {
                chartName.forEach(name => result.push(name));
            }
            else {
                result.push(chartName);
            }
        }
    });
    return result;
};
// Returns events for an interactive legend
const getInteractiveLegendEvents = (props) => [
    ...getInteractiveLegendTargetEvents(Object.assign(Object.assign({}, props), { target: 'data' })),
    ...getInteractiveLegendTargetEvents(Object.assign(Object.assign({}, props), { target: 'labels' }))
];
exports.getInteractiveLegendEvents = getInteractiveLegendEvents;
// Returns legend items, except given ID index
const getInteractiveLegendItems = ({ chartNames, omitIndex }) => {
    const result = [];
    chartNames.map((_, index) => {
        if (index !== omitIndex) {
            result.push(index);
        }
    });
    return result;
};
// Returns styles for interactive legend items
const getInteractiveLegendItemStyles = (hidden = false) => !hidden
    ? {}
    : {
        labels: {
            fill: chart_color_black_500_1.default.value
        },
        symbol: {
            fill: chart_color_black_500_1.default.value,
            type: 'eyeSlash'
        }
    };
exports.getInteractiveLegendItemStyles = getInteractiveLegendItemStyles;
// Returns targeted events for legend 'data' or 'labels'
const getInteractiveLegendTargetEvents = ({ chartNames, isDataHidden = () => false, isHidden = () => false, legendName, onLegendClick = () => null, target }) => {
    if (chartNames === undefined || legendName === undefined) {
        // eslint-disable-next-line no-console
        console.error('getInteractiveLegendTargetEvents:', 'requires chartNames and legendName to be specified');
        return [];
    }
    return chartNames.map((_, index) => {
        // Get IDs to attach events to, except the IDs associated with this event.
        //
        // For example, if the current event key is 0, we need IDs associated with events 1 and 2. If the current event
        // key is 1, we need IDs associated with events 0 and 2. And so on...
        const childNames = getChildNames({ chartNames, legendName, omitIndex: index });
        const legendItems = getInteractiveLegendItems({ chartNames, legendName, omitIndex: index });
        return {
            childName: legendName,
            target,
            eventKey: index,
            eventHandlers: {
                onClick: () => [
                    {
                        // Hide each data series individually
                        target: 'data',
                        mutation: (props) => {
                            onLegendClick(props);
                            return null;
                        }
                    }
                ],
                onMouseOver: () => isHidden(index)
                    ? null
                    : [
                        {
                            // Mute all data series, except the data associated with this event
                            childName: childNames,
                            target: 'data',
                            eventKey: 'all',
                            mutation: (props) => isDataHidden(props.data)
                                ? null
                                : {
                                    // Skip if hidden
                                    style: props.padAngle !== undefined // Support for pie chart
                                        ? Object.assign(Object.assign({}, props.style), (index !== props.index && { opacity: chart_area_Opacity_1.default.value })) : Object.assign(Object.assign({}, props.style), { opacity: chart_area_Opacity_1.default.value })
                                }
                        },
                        {
                            // Mute all legend item symbols, except the symbol associated with this event
                            childName: legendName,
                            target: 'data',
                            eventKey: legendItems,
                            mutation: (props) => isHidden(props.index)
                                ? null
                                : {
                                    // Skip if hidden
                                    style: Object.assign(Object.assign({}, props.style), { opacity: chart_area_Opacity_1.default.value })
                                }
                        },
                        {
                            // Mute all legend item labels, except the label associated with this event
                            childName: legendName,
                            target: 'labels',
                            eventKey: legendItems,
                            mutation: (props) => {
                                const column = props.datum && props.datum.column ? props.datum.column : 0;
                                return isHidden(column)
                                    ? null
                                    : {
                                        // Skip if hidden
                                        style: Object.assign(Object.assign({}, props.style), { opacity: chart_area_Opacity_1.default.value })
                                    };
                            }
                        }
                    ],
                onMouseOut: () => [
                    {
                        // Restore all data series associated with this event
                        childName: 'all',
                        target: 'data',
                        eventKey: 'all',
                        mutation: () => null
                    },
                    {
                        // Restore all legend item symbols associated with this event
                        childName: 'legend',
                        target: 'data',
                        eventKey: legendItems,
                        mutation: () => null
                    },
                    {
                        // Restore all legend item labels associated with this event
                        childName: 'legend',
                        target: 'labels',
                        eventKey: legendItems,
                        mutation: () => null
                    }
                ]
            }
        };
    });
};
//# sourceMappingURL=chart-interactive-legend.js.map