"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartLine = exports.ChartLineSortOrder = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_line_1 = require("victory-line");
const ChartContainer_1 = require("../ChartContainer");
const ChartUtils_1 = require("../ChartUtils");
var ChartLineSortOrder;
(function (ChartLineSortOrder) {
    ChartLineSortOrder["ascending"] = "ascending";
    ChartLineSortOrder["descending"] = "descending";
})(ChartLineSortOrder = exports.ChartLineSortOrder || (exports.ChartLineSortOrder = {}));
const ChartLine = (_a) => {
    var { containerComponent = React.createElement(ChartContainer_1.ChartContainer, null), themeColor, themeVariant, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant) } = _a, rest = tslib_1.__rest(_a, ["containerComponent", "themeColor", "themeVariant", "theme"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ theme }, containerComponent.props));
    // Note: containerComponent is required for theme
    return React.createElement(victory_line_1.VictoryLine, Object.assign({ containerComponent: container, theme: theme }, rest));
};
exports.ChartLine = ChartLine;
exports.ChartLine.displayName = 'ChartLine';
// Note: VictoryLine.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartLine, victory_line_1.VictoryLine);
//# sourceMappingURL=ChartLine.js.map