"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartCursorFlyout = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const prop_types_1 = tslib_1.__importDefault(require("prop-types"));
const victory_core_1 = require("victory-core");
const isPlainObject_1 = tslib_1.__importDefault(require("lodash/isPlainObject"));
const getVerticalPath = (props) => {
    const { pointerWidth, cornerRadius, orientation, width, height, center } = props;
    const sign = orientation === 'bottom' ? 1 : -1;
    // const x = props.x + (props.dx || 0);
    // const y = props.y + (props.dy || 0);
    const centerX = isPlainObject_1.default(center) && center.x;
    const centerY = isPlainObject_1.default(center) && center.y;
    const pointerEdge = centerY + sign * (height / 2);
    const oppositeEdge = centerY - sign * (height / 2);
    const rightEdge = centerX + width / 2;
    const leftEdge = centerX - width / 2;
    // This has been overridden so the pointer does not stick to data points -- want pointerLength to take precedence
    const x = center.x + (props.dx || 0);
    const y = orientation === 'bottom'
        ? pointerEdge + props.pointerLength + (props.dy || 0)
        : pointerEdge - props.pointerLength + (props.dy || 0);
    const pointerLength = sign * (y - pointerEdge) < 0 ? 0 : props.pointerLength;
    const direction = orientation === 'bottom' ? '0 0 0' : '0 0 1';
    const arc = `${cornerRadius} ${cornerRadius} ${direction}`;
    return `M ${centerX - pointerWidth / 2}, ${pointerEdge}
    L ${pointerLength ? x : centerX + pointerWidth / 2}, ${pointerLength ? y : pointerEdge}
    L ${centerX + pointerWidth / 2}, ${pointerEdge}
    L ${rightEdge - cornerRadius}, ${pointerEdge}
    A ${arc} ${rightEdge}, ${pointerEdge - sign * cornerRadius}
    L ${rightEdge}, ${oppositeEdge + sign * cornerRadius}
    A ${arc} ${rightEdge - cornerRadius}, ${oppositeEdge}
    L ${leftEdge + cornerRadius}, ${oppositeEdge}
    A ${arc} ${leftEdge}, ${oppositeEdge + sign * cornerRadius}
    L ${leftEdge}, ${pointerEdge - sign * cornerRadius}
    A ${arc} ${leftEdge + cornerRadius}, ${pointerEdge}
    z`;
};
const getHorizontalPath = (props) => {
    const { pointerWidth, cornerRadius, orientation, width, height, center } = props;
    const sign = orientation === 'left' ? 1 : -1;
    // const x = props.x + (props.dx || 0);
    // const y = props.y + (props.dy || 0);
    const centerX = isPlainObject_1.default(center) && center.x;
    const centerY = isPlainObject_1.default(center) && center.y;
    const pointerEdge = centerX - sign * (width / 2);
    const oppositeEdge = centerX + sign * (width / 2);
    const bottomEdge = centerY + height / 2;
    const topEdge = centerY - height / 2;
    // This has been overridden so the pointer does not stick to data points -- want pointerLength to take precedence
    const x = orientation === 'left'
        ? pointerEdge - props.pointerLength + (props.dx || 0)
        : pointerEdge + props.pointerLength + (props.dx || 0);
    const y = center.y + (props.dy || 0);
    const pointerLength = sign * (x - pointerEdge) > 0 ? 0 : props.pointerLength;
    const direction = orientation === 'left' ? '0 0 0' : '0 0 1';
    const arc = `${cornerRadius} ${cornerRadius} ${direction}`;
    return `M ${pointerEdge}, ${centerY - pointerWidth / 2}
    L ${pointerLength ? x : pointerEdge}, ${pointerLength ? y : centerY + pointerWidth / 2}
    L ${pointerEdge}, ${centerY + pointerWidth / 2}
    L ${pointerEdge}, ${bottomEdge - cornerRadius}
    A ${arc} ${pointerEdge + sign * cornerRadius}, ${bottomEdge}
    L ${oppositeEdge - sign * cornerRadius}, ${bottomEdge}
    A ${arc} ${oppositeEdge}, ${bottomEdge - cornerRadius}
    L ${oppositeEdge}, ${topEdge + cornerRadius}
    A ${arc} ${oppositeEdge - sign * cornerRadius}, ${topEdge}
    L ${pointerEdge + sign * cornerRadius}, ${topEdge}
    A ${arc} ${pointerEdge}, ${topEdge + cornerRadius}
    z`;
};
const getFlyoutPath = (props) => {
    const orientation = props.orientation || 'top';
    return orientation === 'left' || orientation === 'right' ? getHorizontalPath(props) : getVerticalPath(props);
};
const evaluateProps = (props) => {
    /**
     * Potential evaluated props are:
     * `id`
     * `style`
     */
    const id = victory_core_1.Helpers.evaluateProp(props.id, props);
    const style = victory_core_1.Helpers.evaluateStyle(props.style, props);
    return Object.assign({}, props, { id, style });
};
const ChartCursorFlyout = (props) => {
    props = evaluateProps(props);
    return React.cloneElement(props.pathComponent, Object.assign(Object.assign({}, props.events), { style: props.style, d: getFlyoutPath(props), className: props.className, shapeRendering: props.shapeRendering, role: props.role, transform: props.transform, clipPath: props.clipPath }));
};
exports.ChartCursorFlyout = ChartCursorFlyout;
ChartCursorFlyout.propTypes = Object.assign(Object.assign({}, victory_core_1.CommonProps.primitiveProps), { center: prop_types_1.default.shape({ x: prop_types_1.default.number, y: prop_types_1.default.number }), cornerRadius: prop_types_1.default.number, datum: prop_types_1.default.object, dx: prop_types_1.default.number, dy: prop_types_1.default.number, height: prop_types_1.default.number, orientation: prop_types_1.default.oneOf(['top', 'bottom', 'left', 'right']), pathComponent: prop_types_1.default.element, pointerLength: prop_types_1.default.number, pointerWidth: prop_types_1.default.number, width: prop_types_1.default.number, x: prop_types_1.default.number, y: prop_types_1.default.number });
ChartCursorFlyout.defaultProps = {
    pathComponent: React.createElement(victory_core_1.Path, null),
    role: 'presentation',
    shapeRendering: 'auto'
};
//# sourceMappingURL=ChartCursorFlyout.js.map