"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getQualitativeRangeBarWidth = exports.getPrimarySegmentedMeasureWidth = exports.getPrimaryDotMeasureSize = exports.getComparativeMeasureWarningWidth = exports.getComparativeMeasureWidth = exports.getComparativeMeasureErrorWidth = exports.scaleSize = exports.scaleBarWidth = void 0;
const tslib_1 = require("tslib");
const ChartTheme_1 = require("../../ChartTheme");
const ChartUtils_1 = require("../../ChartUtils");
const scaleDimensions = ({ defaultSize, height, horizontal = true, scale = 1, value, width }) => {
    if (horizontal && height > defaultSize) {
        return value + (height - defaultSize) * scale;
    }
    else if (horizontal) {
        return value - (defaultSize - height) * scale;
    }
    else if (width > defaultSize) {
        return value + (width - defaultSize) * scale;
    }
    return value - (defaultSize - width) * scale;
};
// Scale bar width per the given size properties
const scaleBarWidth = (props) => Math.max(scaleDimensions(props), 0);
exports.scaleBarWidth = scaleBarWidth;
// Scale size per the given size properties
const scaleSize = (_a) => {
    var { value } = _a, rest = tslib_1.__rest(_a, ["value"]);
    return Math.round(scaleDimensions(Object.assign({ scale: 1 / value, value }, rest)));
};
exports.scaleSize = scaleSize;
const getComparativeMeasureErrorWidth = ({ height, horizontal, themeColor, themeVariant, width, 
// destructure last
theme = ChartUtils_1.getBulletComparativeErrorMeasureTheme(themeColor, themeVariant) }) => exports.scaleBarWidth({
    defaultSize: theme.bar.height,
    height,
    horizontal,
    value: ChartTheme_1.ChartBulletStyles.comparativeMeasureErrorWidth,
    width
});
exports.getComparativeMeasureErrorWidth = getComparativeMeasureErrorWidth;
const getComparativeMeasureWidth = ({ height, horizontal, themeColor, themeVariant, width, 
// destructure last
theme = ChartUtils_1.getBulletComparativeMeasureTheme(themeColor, themeVariant) }) => exports.scaleBarWidth({
    defaultSize: theme.bar.height,
    height,
    horizontal,
    value: ChartTheme_1.ChartBulletStyles.comparativeMeasureWidth,
    width
});
exports.getComparativeMeasureWidth = getComparativeMeasureWidth;
const getComparativeMeasureWarningWidth = ({ height, horizontal, themeColor, themeVariant, width, 
// destructure last
theme = ChartUtils_1.getBulletComparativeWarningMeasureTheme(themeColor, themeVariant) }) => exports.scaleBarWidth({
    defaultSize: theme.bar.height,
    height,
    horizontal,
    value: ChartTheme_1.ChartBulletStyles.comparativeMeasureWarningWidth,
    width
});
exports.getComparativeMeasureWarningWidth = getComparativeMeasureWarningWidth;
const getPrimaryDotMeasureSize = ({ height, horizontal, themeColor, themeVariant, width, 
// destructure last
theme = ChartUtils_1.getBulletPrimaryDotMeasureTheme(themeColor, themeVariant) }) => exports.scaleSize({
    defaultSize: theme.group.height,
    height,
    horizontal,
    value: ChartTheme_1.ChartBulletStyles.primaryDotMeasureSize,
    width
});
exports.getPrimaryDotMeasureSize = getPrimaryDotMeasureSize;
const getPrimarySegmentedMeasureWidth = ({ height, horizontal, themeColor, themeVariant, width, 
// destructure last
theme = ChartUtils_1.getBulletPrimarySegmentedMeasureTheme(themeColor, themeVariant) }) => exports.scaleBarWidth({
    defaultSize: theme.group.height,
    height,
    horizontal,
    scale: 0.3,
    value: ChartTheme_1.ChartBulletStyles.primarySegmentedMeasureWidth,
    width
});
exports.getPrimarySegmentedMeasureWidth = getPrimarySegmentedMeasureWidth;
const getQualitativeRangeBarWidth = ({ height, horizontal, themeColor, themeVariant, width, 
// destructure last
theme = ChartUtils_1.getBulletQualitativeRangeTheme(themeColor, themeVariant) }) => exports.scaleBarWidth({
    defaultSize: theme.group.height,
    height,
    horizontal,
    value: ChartTheme_1.ChartBulletStyles.qualitativeRangeWidth,
    width
});
exports.getQualitativeRangeBarWidth = getQualitativeRangeBarWidth;
//# sourceMappingURL=chart-bullet-size.js.map