"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartBulletPrimaryDotMeasure = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_scatter_1 = require("victory-scatter");
const utils_1 = require("./utils");
const ChartContainer_1 = require("../ChartContainer");
const ChartScatter_1 = require("../ChartScatter");
const ChartTheme_1 = require("../ChartTheme");
const ChartTooltip_1 = require("../ChartTooltip");
const ChartUtils_1 = require("../ChartUtils");
const ChartBulletPrimaryDotMeasure = ({ allowTooltip = true, ariaDesc, ariaTitle, constrainToVisibleArea = false, data, domain, horizontal = true, invert = false, labels, measureComponent = React.createElement(ChartScatter_1.ChartScatter, null), padding, size = ChartTheme_1.ChartBulletStyles.primaryDotMeasureSize, standalone = true, themeColor, themeVariant, y, y0, 
// destructure last
theme = ChartUtils_1.getBulletPrimaryDotMeasureTheme(themeColor, themeVariant), labelComponent = React.createElement(ChartTooltip_1.ChartTooltip, null), height = theme.group.height, width = theme.group.width }) => {
    const computedData = utils_1.getPrimaryDotMeasureData({
        data,
        invert,
        theme,
        y,
        y0
    });
    // Label component
    //
    // Note: SVG height and width are provided by ChartBullet as a workaround to support constrainToVisibleArea
    const tooltip = React.cloneElement(labelComponent, Object.assign({ constrainToVisibleArea, dx: 0, dy: horizontal ? -size : 0, orientation: 'top' }, labelComponent.props));
    const measure = computedData.map((dataPoint, index) => React.cloneElement(measureComponent, Object.assign({ data: [Object.assign({}, dataPoint)], domain,
        height,
        horizontal, key: `pf-chart-bullet-primary-dot-measure-${index}`, labelComponent: allowTooltip ? tooltip : undefined, labels,
        padding,
        size, standalone: false, style: {
            data: {
                fill: dataPoint._color
            }
        }, theme,
        width }, measureComponent.props)));
    return standalone ? (React.createElement(ChartContainer_1.ChartContainer, { desc: ariaDesc, height: height, title: ariaTitle, width: width }, measure)) : (React.createElement(React.Fragment, null, measure));
};
exports.ChartBulletPrimaryDotMeasure = ChartBulletPrimaryDotMeasure;
exports.ChartBulletPrimaryDotMeasure.displayName = 'ChartBulletPrimaryDotMeasure';
// Note: VictoryBar.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartBulletPrimaryDotMeasure, victory_scatter_1.VictoryScatter);
//# sourceMappingURL=ChartBulletPrimaryDotMeasure.js.map