import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryVoronoiContainer } from 'victory-voronoi-container';
import { ChartTooltip } from '../ChartTooltip';
import { getClassName, getTheme } from '../ChartUtils';
export var ChartVoronoiDimension;
(function (ChartVoronoiDimension) {
    ChartVoronoiDimension["x"] = "x";
    ChartVoronoiDimension["y"] = "y";
})(ChartVoronoiDimension || (ChartVoronoiDimension = {}));
export const ChartVoronoiContainer = (_a) => {
    var { className, constrainToVisibleArea = false, themeColor, themeVariant, 
    // destructure last
    theme = getTheme(themeColor, themeVariant), labelComponent = React.createElement(ChartTooltip, null) } = _a, // Note that Victory provides its own tooltip component here
    rest = __rest(_a, ["className", "constrainToVisibleArea", "themeColor", "themeVariant", "theme", "labelComponent"]);
    const chartClassName = getClassName({ className });
    const chartLabelComponent = React.cloneElement(labelComponent, Object.assign({ constrainToVisibleArea,
        theme }, labelComponent.props));
    // Note: theme is required by voronoiContainerMixin
    return (
    // Note: className is valid, but Victory is missing a type
    React.createElement(VictoryVoronoiContainer, Object.assign({ className: chartClassName, labelComponent: chartLabelComponent, theme: theme }, rest)));
};
ChartVoronoiContainer.displayName = 'ChartVoronoiContainer';
ChartVoronoiContainer.defaultProps = VictoryVoronoiContainer.defaultProps;
// Note: VictoryVoronoiContainer.defaultEvents & VictoryContainer.role must be hoisted
hoistNonReactStatics(ChartVoronoiContainer, VictoryVoronoiContainer);
//# sourceMappingURL=ChartVoronoiContainer.js.map