import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryCursorContainer } from 'victory-cursor-container';
import { ChartLabel } from '../ChartLabel';
import { getClassName, getTheme } from '../ChartUtils';
export const ChartCursorContainer = (_a) => {
    var { className, themeColor, themeVariant, 
    // destructure last
    theme = getTheme(themeColor, themeVariant), cursorLabelComponent = React.createElement(ChartLabel, null) } = _a, // Note that Victory provides its own label component here
    rest = __rest(_a, ["className", "themeColor", "themeVariant", "theme", "cursorLabelComponent"]);
    const chartClassName = getClassName({ className });
    const chartCursorLabelComponent = React.cloneElement(cursorLabelComponent, Object.assign({ theme }, cursorLabelComponent.props));
    // Note: theme is required by voronoiContainerMixin
    return (
    // Note: className is valid, but Victory is missing a type
    React.createElement(VictoryCursorContainer, Object.assign({ className: chartClassName, cursorLabelComponent: chartCursorLabelComponent, theme: theme }, rest)));
};
ChartCursorContainer.displayName = 'ChartCursorContainer';
ChartCursorContainer.defaultProps = VictoryCursorContainer.defaultProps;
// Note: VictoryCursorContainer.defaultEvents & VictoryContainer.role must be hoisted
hoistNonReactStatics(ChartCursorContainer, VictoryCursorContainer);
//# sourceMappingURL=ChartCursorContainer.js.map