import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryContainer } from 'victory-core';
import { getClassName, getTheme } from '../ChartUtils';
export const ChartContainer = (_a) => {
    var { className, themeColor, themeVariant, 
    // destructure last
    theme = getTheme(themeColor, themeVariant) } = _a, rest = __rest(_a, ["className", "themeColor", "themeVariant", "theme"]);
    const chartClassName = getClassName({ className });
    // Note: className is valid, but Victory is missing a type
    return React.createElement(VictoryContainer, Object.assign({ className: chartClassName, theme: theme }, rest));
};
ChartContainer.displayName = 'ChartContainer';
// Note: VictoryContainer.role must be hoisted
hoistNonReactStatics(ChartContainer, VictoryContainer);
//# sourceMappingURL=ChartContainer.js.map