import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryBar } from 'victory-bar';
import { ChartContainer } from '../ChartContainer';
import { getTheme } from '../ChartUtils';
export const ChartBar = (_a) => {
    var { containerComponent = React.createElement(ChartContainer, null), themeColor, themeVariant, 
    // destructure last
    theme = getTheme(themeColor, themeVariant) } = _a, rest = __rest(_a, ["containerComponent", "themeColor", "themeVariant", "theme"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ theme }, containerComponent.props));
    // Note: containerComponent is required for theme
    return React.createElement(VictoryBar, Object.assign({ containerComponent: container, theme: theme }, rest));
};
ChartBar.displayName = 'ChartBar';
// Note: VictoryBar.getDomain & VictoryBar.role must be hoisted
hoistNonReactStatics(ChartBar, VictoryBar);
//# sourceMappingURL=ChartBar.js.map