"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.authInterceptor = authInterceptor;
exports.responseDataInterceptor = responseDataInterceptor;
exports.interceptor401 = interceptor401;
exports.interceptor500 = interceptor500;
exports.errorInterceptor = errorInterceptor;
exports["default"] = exports.instance = exports.HttpError = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _wrapNativeSuper2 = _interopRequireDefault(require("@babel/runtime/helpers/wrapNativeSuper"));

var _axios = _interopRequireDefault(require("axios"));

var _browser = require("@sentry/browser");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var HttpError = /*#__PURE__*/function (_Error) {
  (0, _inherits2["default"])(HttpError, _Error);

  var _super = _createSuper(HttpError);

  function HttpError(description) {
    var _this;

    (0, _classCallCheck2["default"])(this, HttpError);
    _this = _super.call(this, 'Error communicating with the server');
    _this.description = description;
    return _this;
  }

  return HttpError;
}( /*#__PURE__*/(0, _wrapNativeSuper2["default"])(Error));

exports.HttpError = HttpError;

function authInterceptor(_x) {
  return _authInterceptor.apply(this, arguments);
}

function _authInterceptor() {
  _authInterceptor = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(config) {
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return window.insights.chrome.auth.getUser();

          case 2:
            return _context.abrupt("return", config);

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _authInterceptor.apply(this, arguments);
}

function responseDataInterceptor(response) {
  if (response.data) {
    return response.data;
  }

  return response;
}

function interceptor401(error) {
  if (error.response && error.response.status === 401) {
    window.insights.chrome.auth.logout();
    return false;
  }

  throw error;
}

function interceptor500(error) {
  if (error.response && error.response.status >= 500 && error.response.status < 600) {
    (0, _browser.configureScope)(function (scope) {
      scope.setTag('request_id', error.response.req_id);
    });
  }

  throw error;
}

function errorInterceptor(err) {
  if (!_axios["default"].isCancel(err)) {
    var requestId;

    try {
      var _errObject$response, _errObject$response$h;

      var errObject = _objectSpread({}, err);

      requestId = (_errObject$response = errObject.response) === null || _errObject$response === void 0 ? void 0 : (_errObject$response$h = _errObject$response.headers) === null || _errObject$response$h === void 0 ? void 0 : _errObject$response$h['x-rh-insights-request-id'];

      if (errObject.response && errObject.response.data) {
        throw _objectSpread(_objectSpread({}, errObject.response.data), {}, {
          statusText: errObject.response.statusText
        });
      }

      throw err;
    } catch (customError) {
      if (!requestId) {
        customError.sentryId = (0, _browser.captureException)(customError);
      }

      customError.requestId = requestId;
      throw customError;
    }
  }
}

var instance = _axios["default"].create();

exports.instance = instance;
instance.interceptors.request.use(authInterceptor);
instance.interceptors.response.use(responseDataInterceptor);
instance.interceptors.response.use(null, interceptor401);
instance.interceptors.response.use(null, interceptor500);
instance.interceptors.response.use(null, errorInterceptor);
var _default = instance;
exports["default"] = _default;