import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import ReducerRegistry from '../ReducerRegistry';
export var registry;

function init() {
  var initialState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var middleware = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  var composeEnhancersDefault = arguments.length > 2 ? arguments[2] : undefined;

  if (!registry) {
    registry = new ReducerRegistry(initialState, _toConsumableArray(middleware), composeEnhancersDefault);
  }

  registry.register({
    routerData: function routerData(state, _ref) {
      var type = _ref.type,
          payload = _ref.payload;
      return _objectSpread(_objectSpread({}, state), type === '@@INSIGHTS-CORE/NAVIGATION' ? payload : {});
    }
  });
  return registry;
}

export function registryDecorator() {
  return function (target) {
    target.prototype.getRegistry = function () {
      return registry;
    };
  };
}
export function getRegistry() {
  var initialState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var middleware = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  var composeEnhancersDefault = arguments.length > 2 ? arguments[2] : undefined;
  return init(initialState, middleware, composeEnhancersDefault);
}
export default registryDecorator;