import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
export var MiddlewareListener = /*#__PURE__*/function () {
  function MiddlewareListener() {
    _classCallCheck(this, MiddlewareListener);

    this.listeners = new Set();
  }

  _createClass(MiddlewareListener, [{
    key: "getListeners",
    value: function getListeners() {
      return this.listeners;
    }
  }, {
    key: "getMiddleware",
    value: function getMiddleware() {
      var _this = this;

      return function () {
        return function (next) {
          return function (action) {
            var preventBubble = _this.callOnAction(action.type, action.payload);

            if (preventBubble) {
              next({
                type: '@@config/action-stopped',
                payload: action
              });
            } else {
              next(action);
            }
          };
        };
      };
    }
  }, {
    key: "addNew",
    value: function addNew(listener) {
      var _this2 = this;

      this.listeners.add(listener);
      return function () {
        return _this2.listeners["delete"](listener);
      };
    }
  }, {
    key: "callOnAction",
    value: function callOnAction(action, data) {
      var stopBubble = false;

      var preventBubble = function preventBubble() {
        return stopBubble = true;
      };

      var listeners = _toConsumableArray(this.listeners);

      for (var i = 0; i < listeners.length; i++) {
        listeners[i].on === action && listeners[i].hasOwnProperty('callback') && listeners[i].callback({
          data: data,
          preventBubble: preventBubble
        });
      }

      return stopBubble;
    }
  }]);

  return MiddlewareListener;
}();
export default MiddlewareListener;