/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { URI, Utils } from './../../vscode-uri/index.js';
export function dirname(uriString) {
    return Utils.dirname(URI.parse(uriString)).toString();
}
export function joinPath(uriString) {
    var paths = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        paths[_i - 1] = arguments[_i];
    }
    return Utils.joinPath.apply(Utils, __spreadArray([URI.parse(uriString)], paths)).toString();
}
