import { ButtonVariant, PerPageOptions } from '@patternfly/react-core';
import { IRow, ISortBy, ITransform, TableGridBreakpoint } from '@patternfly/react-table';
import React, { ReactNode } from 'react';
declare type SortFn<T> = (a: T, b: T) => number;
declare type CellFn<T> = (item: T) => ReactNode;
declare type SearchFn<T> = (item: T) => string | boolean | number | string[] | boolean[] | number[];
export interface IAcmTableColumn<T> {
    /** the header of the column */
    header: string;
    tooltip?: ReactNode;
    /** enables sort either on field name of using sort function */
    sort?: SortFn<T> | string;
    /** if defined will enable search of the search field */
    search?: SearchFn<T> | string;
    /** cell content, either on field name of using cell function */
    cell: CellFn<T> | string;
    transforms?: ITransform[];
    cellTransforms?: ITransform[];
}
export interface IAcmRowAction<T> {
    /** Action identifier */
    id: string;
    /** Display a tooltip for this action */
    tooltip?: string;
    /** Inject a separator horizontal rule immediately before an action */
    addSeparator?: boolean;
    /** Display an action as being disabled */
    isDisabled?: boolean;
    /** Visible text for action */
    title: string | React.ReactNode;
    /** Function for onClick() action */
    click: (item: T) => void;
}
/**
 * Type for table primary and secondary buttons.
 */
export interface IAcmTableButtonAction {
    id: string;
    title: string | React.ReactNode;
    click: () => void;
    isDisabled?: boolean | undefined;
    tooltip?: string | React.ReactNode;
    variant: ButtonVariant.primary | ButtonVariant.secondary;
}
/**
 * Type for table action
 */
export interface IAcmTableDropdownAction<T> {
    id: string;
    title: string | React.ReactNode;
    click: (items: T[]) => void;
    isDisabled?: boolean;
    tooltip?: string | React.ReactNode;
    variant: 'dropdown-action';
}
/**
 * Type for bulk actions on table items
 */
export interface IAcmTableBulkAction<T> {
    id: string;
    title: string | React.ReactNode;
    click: (items: T[]) => void;
    isDisabled?: boolean;
    tooltip?: string | React.ReactNode;
    variant: 'bulk-action';
}
/**
 * Type for separator line in action dropdown
 */
export interface IAcmTableActionSeperator {
    id: string;
    variant: 'action-seperator';
}
/**
 * Type for table action dropdown options group
 */
export interface IAcmTableActionGroup<T> {
    id: string;
    title: string | React.ReactNode;
    actions: IAcmTableBulkAction<T>[] | IAcmTableDropdownAction<T>[];
    variant: 'action-group';
}
export declare type IAcmTableAction<T> = IAcmTableDropdownAction<T> | IAcmTableBulkAction<T> | IAcmTableActionSeperator | IAcmTableActionGroup<T>;
declare type FilterOptionValueT = string;
declare type TableFilterOption<FilterOptionValueT> = {
    label: ReactNode;
    value: FilterOptionValueT;
};
export declare type TableFilterFn<T> = (selectedValues: string[], item: T) => boolean;
/**
 * Interface defining required params for table filtering property "filterItems"
 * @interface
 * @param {string} label - label is the string displayed in UI
 * @param {string} id - ID is unique identifier
 * @param {TableFilterOption<FilterOptionValueT>[]} options - Options is an array to define the exact filter options
 * @param {TableFilterFn<T>} tableFilterFn - A required function that returns a boolean if the item is a match to the current filters
 */
export interface ITableFilter<T> {
    label: string;
    id: string;
    options: TableFilterOption<FilterOptionValueT>[];
    tableFilterFn: TableFilterFn<T>;
    showEmptyOptions?: boolean;
}
export declare function AcmTablePaginationContextProvider(props: {
    children: ReactNode;
    localStorageKey: string;
}): JSX.Element;
export interface AcmTableProps<T> {
    plural: string;
    items?: T[];
    addSubRows?: (item: T) => IRow[] | undefined;
    initialSelectedItems?: T[];
    columns: IAcmTableColumn<T>[];
    keyFn: (item: T) => string;
    groupFn?: (item: T) => string | null;
    groupSummaryFn?: (items: T[]) => IRow;
    customTableAction?: ReactNode;
    tableActionButtons?: IAcmTableButtonAction[];
    tableActions?: IAcmTableAction<T>[];
    rowActions?: IAcmRowAction<T>[];
    rowActionResolver?: (item: T) => IAcmRowAction<T>[];
    extraToolbarControls?: ReactNode;
    emptyState?: ReactNode;
    onSelect?: (items: T[]) => void;
    page?: number;
    setPage?: (page: number) => void;
    search?: string;
    setSearch?: (search: string) => void;
    searchPlaceholder?: string;
    initialSort?: ISortBy | undefined;
    sort?: ISortBy | undefined;
    setSort?: (sort: ISortBy | undefined) => void;
    showToolbar?: boolean;
    gridBreakPoint?: TableGridBreakpoint;
    perPageOptions?: PerPageOptions[];
    autoHidePagination?: boolean;
    noBorders?: boolean;
    fuseThreshold?: number;
    filters?: ITableFilter<T>[];
}
export declare function AcmTable<T>(props: AcmTableProps<T>): JSX.Element;
export declare function compareItems(path: string): (a: unknown, b: unknown) => 0 | 1 | -1;
export declare function compareUnknowns(a: unknown | undefined | null, b: unknown | undefined | null): 0 | 1 | -1;
export declare function compareStrings(a: string | undefined | null, b: string | undefined | null): 0 | 1 | -1;
export declare function compareNumbers(a: number | undefined | null, b: number | undefined | null): 0 | 1 | -1;
export interface TableSelectionDropdownProps {
    itemCount: number;
    selectedCount: number;
    perPage: number;
    onSelectNone: () => void;
    onSelectPage: () => void;
    onSelectAll: () => void;
}
export declare function TableSelectionDropdown(props: TableSelectionDropdownProps): JSX.Element;
export {};
