"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmFormProvider = exports.FormContext = exports.AcmSubmit = exports.AcmForm = exports.useValidationContext = exports.AcmValidationProvider = exports.useValidationState = exports.ValidationContext = exports.hasValidationErrors = void 0;
var react_core_1 = require("@patternfly/react-core");
var react_1 = __importStar(require("react"));
var AcmAlert_1 = require("../AcmAlert/AcmAlert");
function hasValidationErrors(state) {
    return Object.values(state.errors).filter(function (v) { return v; }).length > 0;
}
exports.hasValidationErrors = hasValidationErrors;
exports.ValidationContext = react_1.createContext({
    validate: false,
    setValidate: noop,
    errors: {},
    setError: noop,
    isReadOnly: false,
    setReadOnly: noop,
});
function useValidationState() {
    var _a = react_1.useState({
        validate: false,
        errors: {},
        isReadOnly: false,
    }), validationState = _a[0], setValidationState = _a[1];
    var setValidate = react_1.useCallback(function (validate) {
        setValidationState(function (validationState) { return (__assign(__assign({}, validationState), { validate: validate })); });
    }, []);
    var setReadOnly = react_1.useCallback(function (isReadOnly) {
        setValidationState(function (validationState) { return (__assign(__assign({}, validationState), { isReadOnly: isReadOnly })); });
    }, []);
    var setError = react_1.useCallback(function (id, error) {
        setValidationState(function (validationState) {
            var _a;
            var newState = __assign({}, validationState);
            if (!error) {
                newState.errors = __assign({}, newState.errors);
                delete newState.errors[id];
            }
            else {
                newState.errors = __assign(__assign({}, newState.errors), (_a = {}, _a[id] = error, _a));
            }
            return newState;
        });
    }, []);
    var validationContext = react_1.useMemo(function () { return (__assign({ setValidate: setValidate, setReadOnly: setReadOnly, setError: setError }, validationState)); }, [validationState]);
    return validationContext;
}
exports.useValidationState = useValidationState;
function AcmValidationProvider(props) {
    var validationState = useValidationState();
    return react_1.default.createElement(exports.ValidationContext.Provider, { value: validationState }, props.children);
}
exports.AcmValidationProvider = AcmValidationProvider;
function useValidationContext() {
    return react_1.useContext(exports.ValidationContext);
}
exports.useValidationContext = useValidationContext;
function AcmForm(props) {
    return (react_1.default.createElement(AcmValidationProvider, null,
        react_1.default.createElement(react_core_1.Form, __assign({}, props, { onSubmit: /* istanbul ignore next */ function (e) { return e.preventDefault(); } }))));
}
exports.AcmForm = AcmForm;
function AcmSubmit(props) {
    var _this = this;
    var _a;
    var validationContext = react_1.useContext(exports.ValidationContext);
    var alertContext = react_1.useContext(AcmAlert_1.AcmAlertContext);
    var _b = react_1.useState(false), isDisabled = _b[0], setDisabled = _b[1];
    var _c = react_1.default.useState(false), isLoading = _c[0], setIsLoading = _c[1];
    var isMountedRef = react_1.default.useRef(false);
    react_1.useEffect(function () {
        isMountedRef.current = true;
        return function () {
            isMountedRef.current = false;
        };
    }, []);
    react_1.useEffect(function () {
        if (validationContext.validate) {
            var hasError = hasValidationErrors(validationContext);
            setDisabled(hasError);
            if (!hasError) {
                alertContext.clearAlerts(function (alert) { return alert.group === 'validation'; });
            }
        }
    }, [validationContext.errors]);
    return (react_1.default.createElement(react_core_1.Button, { type: "submit", variant: (_a = props.variant) !== null && _a !== void 0 ? _a : 'primary', spinnerAriaValueText: isLoading ? 'Loading' : undefined, isLoading: isLoading, onClick: function (event) { return __awaiter(_this, void 0, void 0, function () {
            var hasError, err_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        hasError = hasValidationErrors(validationContext);
                        if (!hasError) return [3 /*break*/, 1];
                        validationContext.setValidate(true);
                        setDisabled(hasError);
                        alertContext.addAlert({
                            type: 'danger',
                            title: 'Validation errors detected',
                            group: 'validation',
                            id: 'validation',
                        });
                        return [3 /*break*/, 6];
                    case 1:
                        setIsLoading(true);
                        validationContext.setReadOnly(true);
                        if (!props.onClick) return [3 /*break*/, 6];
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 5]);
                        return [4 /*yield*/, props.onClick(event)];
                    case 3:
                        _a.sent();
                        return [3 /*break*/, 5];
                    case 4:
                        err_1 = _a.sent();
                        return [3 /*break*/, 5];
                    case 5:
                        // In cases where the onClick caused a route change and the component is unmounted
                        // we need to wait for that to process and only after that if we are still mounted
                        // set the states
                        /* istanbul ignore next */
                        setTimeout(function () {
                            if (isMountedRef.current) {
                                validationContext.setReadOnly(false);
                                setIsLoading(false);
                            }
                        }, 0);
                        _a.label = 6;
                    case 6: return [2 /*return*/];
                }
            });
        }); }, isDisabled: isLoading || isDisabled || props.isDisabled }, props.label ? (isLoading ? props.processingLabel : props.label) : props.children));
}
exports.AcmSubmit = AcmSubmit;
function noop() {
    // Do Nothing
}
/** @deprecated Deprecated - use ValidationContext instead */
exports.FormContext = exports.ValidationContext;
/** @deprecated Deprecated - use AcmValidationProvider instead */
exports.AcmFormProvider = AcmValidationProvider;
//# sourceMappingURL=AcmForm.js.map