"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmExpandableCard = void 0;
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
var styles_1 = require("@material-ui/styles");
var useStyles = styles_1.makeStyles({
    header: { 'border-bottom': '1px solid rgba(0,0,0,0.1)', cursor: 'pointer' },
    body: {
        padding: '32px 24px',
        '& > .pf-c-card__body': {
            padding: '0px',
        },
    },
});
var onToggle = function (acmCardID, open, setOpen) {
    setOpen(!open);
    if (localStorage.getItem(acmCardID) === 'show') {
        localStorage.setItem(acmCardID, 'hide');
    }
    else {
        localStorage.setItem(acmCardID, 'show');
    }
};
function AcmExpandableCard(props) {
    var _a;
    var acmCardID = window.location.href + props.id;
    (_a = localStorage.getItem(acmCardID)) !== null && _a !== void 0 ? _a : localStorage.setItem(acmCardID, 'show');
    var _b = react_1.useState(localStorage.getItem(acmCardID) === 'show'), open = _b[0], setOpen = _b[1];
    var classes = useStyles();
    return (react_1.default.createElement(react_core_1.Card, { id: props.id, className: props.className, isExpanded: open },
        react_1.default.createElement(react_core_1.CardHeader, { className: classes.header, onExpand: function () { return onToggle(acmCardID, open, setOpen); }, onClick: function () { return onToggle(acmCardID, open, setOpen); }, toggleButtonProps: {
                id: 'toggle-button',
                'aria-label': 'Toggle details',
                'aria-expanded': open,
            } },
            react_1.default.createElement(react_core_1.CardTitle, null, props.title)),
        react_1.default.createElement(react_core_1.CardExpandableContent, { className: classes.body },
            react_1.default.createElement(react_core_1.CardBody, null, props.children))));
}
exports.AcmExpandableCard = AcmExpandableCard;
//# sourceMappingURL=AcmExpandableCard.js.map