"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmDescriptionList = void 0;
var styles_1 = require("@material-ui/styles");
var react_core_1 = require("@patternfly/react-core");
var react_1 = __importDefault(require("react"));
var AcmExpandable_1 = require("../AcmExpandable");
var useStyles = styles_1.makeStyles({
    leftCol: (_a = {
            'margin-bottom': '0px'
        },
        _a['@media (max-width:768px)'] = {
            'margin-bottom': 'var(--pf-global--gutter--md)',
        },
        _a['margin-right'] = 'var(--pf-global--gutter--md)',
        _a),
});
function AcmDescriptionList(props) {
    var classes = useStyles();
    return (react_1.default.createElement(AcmExpandable_1.AcmExpandableCard, { title: props.title },
        react_1.default.createElement(react_core_1.Grid, { sm: 12, md: props.rightItems ? 6 : 12 },
            react_1.default.createElement(react_core_1.GridItem, { className: classes.leftCol },
                react_1.default.createElement(List, { items: props.leftItems })),
            props.rightItems && (react_1.default.createElement(react_core_1.GridItem, null,
                react_1.default.createElement(List, { items: props.rightItems }))))));
}
exports.AcmDescriptionList = AcmDescriptionList;
var List = function (props) {
    return (react_1.default.createElement(react_core_1.DescriptionList, { isHorizontal: true }, props.items.map(function (_a) {
        var key = _a.key, keyAction = _a.keyAction, value = _a.value;
        return (react_1.default.createElement(react_core_1.DescriptionListGroup, { key: key },
            react_1.default.createElement(react_core_1.DescriptionListTerm, null,
                key,
                " ",
                keyAction),
            react_1.default.createElement(react_core_1.DescriptionListDescription, null, value !== null && value !== void 0 ? value : '-')));
    })));
};
//# sourceMappingURL=AcmDescriptionList.js.map