"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmCountCardSection = void 0;
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var AcmExpandable_1 = require("../AcmExpandable");
var styles_1 = require("@material-ui/styles");
var useStyles = styles_1.makeStyles({
    section: {
        '& > .pf-c-card__body': {
            padding: '0 !important',
        },
        '& > .pf-c-card__expandable-content': {
            padding: '0px',
        },
    },
    card: {
        height: '159px',
        padding: '32px 0 24px 24px',
        borderLeft: '1px solid rgba(0,0,0,0.1)',
        marginTop: '-1px',
    },
    cardFirst: {
        borderLeft: '0',
    },
    countContainer: {
        fontSize: '36px',
    },
    count: {
        textDecoration: 'none !important',
        fontWeight: 100,
    },
    countDanger: {
        color: 'var(--pf-global--danger-color--100)',
        textDecoration: 'none !important',
        fontWeight: 100,
        '&:hover': {
            color: 'var(--pf-global--palette--red-300)',
        },
    },
    title: {
        fontSize: '14px !important',
        fontWeight: 600,
    },
    titleIcon: {
        marginRight: '8px',
    },
    description: {
        color: 'var(--pf-global--disabled-color--100)',
        marginTop: '8px',
        fontSize: '14px',
    },
    link: {
        marginTop: '8px',
        fontSize: '14px',
    },
});
var AcmCountCardSection = function (props) {
    var classes = useStyles();
    var cardCount = props.cards.length;
    // Grid uses a 12 column layout - here we find the number of coulumns to evenly use per item
    // If 12 / cardCount doesnt come out to a whole number we round up and the extra card will be displayed on a second row
    var gridNum = Math.ceil(12 / cardCount);
    return (react_1.default.createElement(AcmExpandable_1.AcmExpandableCard, { title: props.title, className: classes.section, id: props.id },
        react_1.default.createElement(react_core_1.Grid, { sm: gridNum }, props.cards.map(function (card, i) {
            return (react_1.default.createElement(react_core_1.GridItem, { key: i }, props.loading ? (react_1.default.createElement(LoadingCard, __assign({}, card, { loadingAriaLabel: props.loadingAriaLabel }))) : (react_1.default.createElement("div", { id: card.id, className: classes.card + " " + (i === 0 ? classes.cardFirst : '') },
                react_1.default.createElement("div", { className: classes.countContainer }, card.countClick && card.count > 0 ? (react_1.default.createElement("a", { onClick: card.countClick, className: card.isDanger ? classes.countDanger : classes.count }, card.count)) : (card.count)),
                react_1.default.createElement("div", { className: classes.title },
                    react_1.default.createElement("span", null,
                        card.isDanger && card.count > 0 && (react_1.default.createElement(react_icons_1.ExclamationCircleIcon, { color: "var(--pf-global--danger-color--100)", className: classes.titleIcon })),
                        card.title)),
                card.description && react_1.default.createElement("div", { className: classes.description }, card.description),
                card.linkText && (react_1.default.createElement("div", { className: classes.link },
                    react_1.default.createElement("a", { onClick: card.onLinkClick }, card.linkText)))))));
        }))));
};
exports.AcmCountCardSection = AcmCountCardSection;
var LoadingCard = function (props) {
    var classes = useStyles();
    return (react_1.default.createElement("div", { id: props.id, className: classes.card, role: "progressbar", "aria-label": props.loadingAriaLabel },
        react_1.default.createElement("div", { className: classes.countContainer },
            react_1.default.createElement(react_core_1.Skeleton, { style: { width: '44px', height: '48px', marginBottom: '12px' } })),
        react_1.default.createElement("div", { className: classes.title, style: { marginBottom: '12px' } },
            react_1.default.createElement("span", null,
                react_1.default.createElement(react_core_1.Skeleton, { style: { width: '130px', height: '21px', padding: '3px 0' } }))),
        props.description && (react_1.default.createElement("div", { className: classes.description },
            react_1.default.createElement(react_core_1.Skeleton, { style: { width: '130px', height: '21px', padding: '3px 0' } }))),
        props.linkText && (react_1.default.createElement("div", { className: classes.link },
            react_1.default.createElement(react_core_1.Skeleton, { style: { width: '130px', height: '21px', padding: '3px 0' } })))));
};
//# sourceMappingURL=AcmCountCardSection.js.map