"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmToast = exports.AcmToastGroup = exports.AcmToastProvider = exports.AcmToastContext = void 0;
var Slide_1 = __importDefault(require("@material-ui/core/Slide"));
var react_core_1 = require("@patternfly/react-core");
var react_1 = __importStar(require("react"));
/* istanbul ignore next */
var noop = function () { return null; };
exports.AcmToastContext = react_1.createContext({
    activeAlerts: [],
    alertInfos: [],
    addAlert: noop,
    removeAlert: noop,
    removeVisibleAlert: noop,
    clearAlerts: noop,
});
function AcmToastProvider(props) {
    var _a = react_1.useState([]), activeAlerts = _a[0], setActiveAlerts = _a[1];
    var _b = react_1.useState([]), visibleAlerts = _b[0], setVisibleAlerts = _b[1];
    var addAlert = react_1.useCallback(function (alert) {
        alert.id = Math.random().toString(36).substring(7);
        setActiveAlerts(function (alerts) { return __spreadArray(__spreadArray([], alerts), [alert]); });
        setVisibleAlerts(function (alerts) { return __spreadArray(__spreadArray([], alerts), [alert]); });
    }, []);
    var removeAlert = react_1.useCallback(function (alertInfo) {
        setActiveAlerts(function (activeAlerts) {
            var index = activeAlerts.findIndex(function (ai) { return ai.id === alertInfo.id; });
            var newAlertInfos = __spreadArray([], activeAlerts);
            /* istanbul ignore else */
            if (index !== -1)
                newAlertInfos.splice(index, 1);
            return newAlertInfos;
        });
    }, []);
    var removeVisibleAlert = react_1.useCallback(function (alertInfo) {
        setVisibleAlerts(function (alertInfos) {
            var index = alertInfos.findIndex(function (ai) { return ai.id === alertInfo.id; });
            var newAlertInfos = __spreadArray([], alertInfos);
            /* istanbul ignore else */
            if (index !== -1)
                newAlertInfos.splice(index, 1);
            return newAlertInfos;
        });
    }, []);
    var clearAlerts = function (matcher) {
        if (!matcher) {
            for (var _i = 0, _a = __spreadArray([], activeAlerts); _i < _a.length; _i++) {
                var alertInfo = _a[_i];
                removeAlert(alertInfo);
            }
        }
        else {
            var removeAlerts = activeAlerts.filter(matcher);
            for (var _b = 0, removeAlerts_1 = removeAlerts; _b < removeAlerts_1.length; _b++) {
                var alertInfo = removeAlerts_1[_b];
                removeAlert(alertInfo);
            }
        }
    };
    return (react_1.default.createElement(exports.AcmToastContext.Provider, { value: {
            activeAlerts: activeAlerts,
            alertInfos: visibleAlerts,
            addAlert: addAlert,
            removeAlert: removeAlert,
            removeVisibleAlert: removeVisibleAlert,
            clearAlerts: clearAlerts,
        } }, props.children));
}
exports.AcmToastProvider = AcmToastProvider;
function AcmToastGroup() {
    var alertContext = react_1.useContext(exports.AcmToastContext);
    var _a = react_1.useState(false), hasAlerts = _a[0], setHasAlerts = _a[1];
    react_1.useEffect(function () { return setHasAlerts(alertContext.alertInfos.length > 0); }, [alertContext.alertInfos]);
    if (!hasAlerts)
        return react_1.default.createElement(react_1.Fragment, null);
    return (react_1.default.createElement(react_core_1.AlertGroup, { isToast: true },
        react_1.default.createElement(react_core_1.Flex, { direction: { default: 'column' } }, alertContext.alertInfos.map(function (alertInfo) {
            /* istanbul ignore next */
            return react_1.default.createElement(AcmToast, { key: alertInfo.id, alertInfo: alertInfo });
        }))));
}
exports.AcmToastGroup = AcmToastGroup;
function AcmToast(props) {
    var alertContext = react_1.useContext(exports.AcmToastContext);
    var alertInfo = props.alertInfo;
    var _a = react_1.useState(false), open = _a[0], setOpen = _a[1];
    react_1.useEffect(function () { return setOpen(true); }, []);
    react_1.useEffect(function () {
        if (alertInfo && !alertContext.activeAlerts.find(function (a) { return a.id === alertInfo.id; })) {
            setOpen(false);
        }
    }, [alertContext]);
    react_1.useEffect(function () {
        if (alertInfo === null || alertInfo === void 0 ? void 0 : alertInfo.autoClose) {
            setTimeout(function () { return setOpen(false); }, 5000);
        }
    }, []);
    return (react_1.default.createElement(Slide_1.default, { in: open, direction: "left", mountOnEnter: true, unmountOnExit: true, onExit: function () {
            /* istanbul ignore else */
            if (alertInfo) {
                setTimeout(function () {
                    alertContext.removeAlert(alertInfo);
                    alertContext.removeVisibleAlert(alertInfo);
                }, 150);
            }
        }, timeout: 150 },
        react_1.default.createElement("div", null,
            react_1.default.createElement(react_core_1.Alert, { title: (alertInfo === null || alertInfo === void 0 ? void 0 : alertInfo.title) || props.title, actionClose: react_1.default.createElement(react_core_1.AlertActionCloseButton, { onClose: function () { return setOpen(false); } }), variant: (alertInfo === null || alertInfo === void 0 ? void 0 : alertInfo.type) || props.variant, style: props.style, className: props.className }, (alertInfo === null || alertInfo === void 0 ? void 0 : alertInfo.message) || props.message || props.subtitle))));
}
exports.AcmToast = AcmToast;
//# sourceMappingURL=AcmToast.js.map